/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMBlobInputStream;
import com.raima.rdm.jdbc.RDMBlobOutputStream;
import com.raima.rdm.util.BlobHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Logger;

public class RDMBlob
implements Blob {
    private boolean freed = false;
    private BlobHandler blobHandler;
    private Logger logger;
    private static final String className = "RDMBlob";
    private static final String blobAlreadyFreed = "Blob already freed";
    private static final String invalidParameter = "invalid parameter";
    private static final String errorAccessingBlob = "error accessing Blob";
    private static final int PARTLENGTH = 256;

    public RDMBlob() throws SQLException {
        try {
            this.blobHandler = new BlobHandler();
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingBlob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    public RDMBlob(byte[] bytes) throws SQLException {
        try {
            this.blobHandler = new BlobHandler(bytes);
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingBlob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    public RDMBlob(InputStream is) throws SQLException {
        try {
            this.blobHandler = new BlobHandler(is);
        }
        catch (IOException e) {
            throw new SQLException(errorAccessingBlob, e);
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    }

    @Override
    public void free() throws SQLException {
        String methodName = "free";
        this.logger.entering(className, methodName);
        if (!this.freed) {
            this.blobHandler.close();
            this.freed = true;
        }
        this.logger.exiting(className, methodName);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        String methodName = "getBinaryStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        RDMBlobInputStream is = null;
        try {
            is = new RDMBlobInputStream(this.blobHandler);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, is);
        return is;
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        String methodName = "getBinaryStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        RDMBlobInputStream is = null;
        try {
            if (--pos < 0L || len < 0L || pos + len > this.blobHandler.size()) {
                throw this.createSQLException(methodName, invalidParameter);
            }
            is = new RDMBlobInputStream(this.blobHandler, pos, len);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, is);
        return is;
    }

    @Override
    public byte[] getBytes(long pos, int len) throws SQLException {
        String methodName = "getBytes";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        byte[] copy = null;
        try {
            long size = this.blobHandler.size();
            if (--pos < 0L || len < 0 || pos + (long)len > size) {
                throw this.createSQLException(methodName, invalidParameter);
            }
            if ((long)len > size - pos) {
                len = (int)(size - pos);
            }
            copy = new byte[len];
            this.blobHandler.read(pos, copy, 0, len);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, copy);
        return copy;
    }

    @Override
    public long length() throws SQLException {
        long len;
        String methodName = "length";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        try {
            len = this.blobHandler.size();
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, len);
        return len;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        String methodName = "position";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        if (start < 1L || pattern == null) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            long end = this.blobHandler.size() - pattern.length();
            byte[] firstPatternPart = pattern.getBytes(1L, (int)Math.min(256L, pattern.length()));
            for (long ii = start - 1L; ii <= end; ++ii) {
                long jj;
                byte[] patternPart = null;
                for (jj = 0L; jj < (long)firstPatternPart.length && this.blobHandler.read(ii + jj) == firstPatternPart[(int)jj]; ++jj) {
                }
                if (jj == (long)firstPatternPart.length) {
                    while (jj < pattern.length()) {
                        if (jj % 256L == 0L) {
                            patternPart = pattern.getBytes(jj + 1L, (int)Math.min(256L, pattern.length() - jj));
                        }
                        if (this.blobHandler.read(ii + jj) != patternPart[(int)(jj % 256L)]) break;
                        ++jj;
                    }
                }
                if (jj != pattern.length()) continue;
                this.logger.exiting(className, methodName, ii + 1L);
                return ii + 1L;
            }
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, -1);
        return -1L;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        String methodName = "position";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        if (start < 1L || pattern == null) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            long end = this.blobHandler.size() - (long)pattern.length;
            for (long ii = start - 1L; ii <= end; ++ii) {
                int jj;
                for (jj = 0; jj < pattern.length && this.blobHandler.read(ii + (long)jj) == pattern[jj]; ++jj) {
                }
                if (jj != pattern.length) continue;
                this.logger.exiting(className, methodName, ii + 1L);
                return ii + 1L;
            }
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, -1);
        return -1L;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        String methodName = "setBinaryStream";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        if (--pos < 0L) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        RDMBlobOutputStream os = new RDMBlobOutputStream(this.blobHandler, pos);
        this.logger.exiting(className, methodName, os);
        return os;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes == null ? 0 : bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        String methodName = "setBytes";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        if (--pos < 0L || bytes == null || offset < 0 || len < 0 || offset + len > bytes.length) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            this.blobHandler.write(pos, bytes, offset, len);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName, len);
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        String methodName = "truncate";
        this.logger.entering(className, methodName);
        if (this.freed) {
            throw this.createSQLException(methodName, blobAlreadyFreed);
        }
        if (len < 0L) {
            throw this.createSQLException(methodName, invalidParameter);
        }
        try {
            this.blobHandler.truncate(len);
        }
        catch (IOException e) {
            throw this.createSQLException(methodName, errorAccessingBlob, e);
        }
        this.logger.exiting(className, methodName);
    }

    private SQLException createSQLException(String methodName, String string) throws SQLException {
        return this.createSQLException(methodName, string, null);
    }

    private SQLException createSQLException(String methodName, String string, Throwable cause) throws SQLException {
        SQLException sqlex = new SQLException(string, cause);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

