/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3fs;

import com.dbeaver.cloud.aws.s3fs.S3ClientGetter;
import com.dbeaver.cloud.aws.s3fs.S3FileStore;
import com.dbeaver.cloud.aws.s3fs.S3FileSystemProvider;
import com.dbeaver.cloud.aws.s3fs.S3Path;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;

public class S3FileSystem
extends FileSystem
implements Comparable<S3FileSystem> {
    private static final Log LOGGER = Log.getLog(S3FileSystem.class);
    private final S3FileSystemProvider provider;
    private final S3ClientGetter clientGetter;
    private S3Client client;
    private final String endpoint;
    private final int cache;
    private final String fsId;
    private final Bucket bucket;

    public S3FileSystem(S3FileSystemProvider provider, String fsId, Bucket bucket, S3ClientGetter clientGetter, String endpoint) {
        this.provider = provider;
        this.fsId = fsId;
        this.bucket = bucket;
        this.clientGetter = clientGetter;
        this.endpoint = endpoint;
        this.cache = 60000;
    }

    @Override
    public S3FileSystemProvider provider() {
        return this.provider;
    }

    public String getKey() {
        return this.fsId;
    }

    @Override
    public void close() {
        this.provider.close(this);
    }

    @Override
    public boolean isOpen() {
        return this.provider.isOpen(this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FileStore fileStore : this.getFileStores()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Stream<Path> list = Files.list(((S3FileStore)fileStore).getRootDirectory());){
                    list.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error reading bucket contents", (Throwable)e);
            }
        }
        return builder.build();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.singletonList(new S3FileStore(this, this.bucket.name()));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return ImmutableSet.of((Object)"basic", (Object)"posix");
    }

    @Override
    @NotNull
    public S3Path getPath(@NotNull String first, String ... more) {
        if (more.length == 0) {
            return new S3Path(this, first, new String[0]);
        }
        return new S3Path(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public S3Client getClient() {
        if (this.client == null) {
            this.client = this.clientGetter.obtainClient();
        }
        return this.client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String[] key2Parts(String keyParts) {
        String[] parts = keyParts.split("/");
        String[] split = new String[parts.length];
        int i = 0;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            split[i++] = part;
            ++n2;
        }
        return split;
    }

    public int hashCode() {
        String key = this.bucket.name();
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (key == null ? 0 : key.hashCode());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileSystem)) {
            return false;
        }
        S3FileSystem s3FileSystem = (S3FileSystem)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.bucket == null) {
            return other.bucket == null;
        }
        return this.bucket.equals((Object)other.bucket);
    }

    @Override
    public int compareTo(S3FileSystem o) {
        return this.bucket.name().compareTo(o.bucket.name());
    }

    public int getCache() {
        return this.cache;
    }

    public Bucket getBucket() {
        return this.bucket;
    }
}

