/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3;

import com.dbeaver.cloud.aws.s3.AWSFileSystemS3;
import com.dbeaver.cloud.aws.s3fs.S3FileStore;
import com.dbeaver.cloud.aws.s3fs.S3FileSystem;
import com.dbeaver.cloud.aws.s3fs.S3FileSystemProvider;
import com.dbeaver.cloud.model.CPCloudFileSystemRoot;
import com.dbeaver.cloud.model.navigator.CPCloudRegionProvider;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;

public class AWSFileSystemS3Bucket
implements CPCloudFileSystemRoot,
CPCloudRegionProvider {
    private static final S3FileSystemProvider provider = new S3FileSystemProvider();
    private final AWSFileSystemS3 fs;
    private final Region region;
    private final Bucket bucket;
    private S3FileStore fileStore;

    public AWSFileSystemS3Bucket(AWSFileSystemS3 fs, Region region, Bucket bucket) {
        this.fs = fs;
        this.region = region;
        this.bucket = bucket;
    }

    @NotNull
    public String getName() {
        return this.bucket.name();
    }

    @NotNull
    public DBFVirtualFileSystem getFileSystem() {
        return this.fs;
    }

    @NotNull
    public String getRootId() {
        return this.bucket.name();
    }

    public DBPImage getRootIcon() {
        return null;
    }

    @NotNull
    public Path getRootPath(DBRProgressMonitor monitor) throws DBException {
        if (this.fileStore == null) {
            S3Client s3Client = this.fs.getS3Client(monitor, this.region);
            S3FileSystem s3FileSystem = new S3FileSystem(provider, this.fs.getId(), this.bucket, () -> s3Client, "s3.amazonaws.com");
            this.fileStore = new S3FileStore(s3FileSystem, this.bucket.name());
        }
        return this.fileStore.getRootDirectory();
    }

    @Nullable
    public String getCloudRegion(@Nullable DBRProgressMonitor monitor) {
        return this.region.id();
    }

    public String toString() {
        return this.bucket.toString();
    }
}

