/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.functions;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.utils.CommonUtils;

public class AIFunctionOpenSQLEditor
implements AIFunction {
    private static final Log log = Log.getLog(AIFunctionOpenSQLEditor.class);
    private static final String PARAM_SQL_TEXT = "sqlText";
    private static final String PARAM_NEW_EDITOR = "newEditor";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String sqlText = JSONUtils.getString(parameters, (String)PARAM_SQL_TEXT, (String)"");
        boolean newEditor = JSONUtils.getBoolean(parameters, (String)PARAM_NEW_EDITOR, (boolean)CommonUtils.isNotEmpty((String)sqlText));
        SQLNavigatorContext sqlContext = context.getContext() != null ? new SQLNavigatorContext(context.getContext().getDataSource().getDataSourceContainer(), null) : new SQLNavigatorContext();
        DBRRunnableWithReturn callback = monitor -> {
            UIUtils.asyncExec(() -> {
                try {
                    if (newEditor) {
                        SQLEditorHandlerOpenEditor.openNewEditor((SQLNavigatorContext)sqlContext, null);
                    } else {
                        SQLEditorHandlerOpenEditor.openRecentScript((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (SQLNavigatorContext)sqlContext, null);
                    }
                }
                catch (CoreException e) {
                    log.error((Object)e);
                }
            });
            return null;
        };
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, newEditor ? "Open new SQL Editor" : "Open recent SQL Editor", callback);
    }
}

