/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.ui.ai.internal.AIUIActivatorPro;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class WebCSSInitializer {
    private static final Log log = Log.getLog(WebCSSInitializer.class);
    private static final String WEB_CSS_PATH = "web/styles.css";
    private static final String WEB_HTML_PATH = "web/index.html";
    private static final String WEB_MARKED_PATH = "web/marked.umd.js";
    private static final String WEB_SCRIPT_PATH = "web/script.js";
    private final Path directory;

    public WebCSSInitializer() throws IOException {
        AIUIActivatorPro activator = AIUIActivatorPro.getInstance();
        this.directory = Files.createTempDirectory("dbeaver-ai-chat", new FileAttribute[0]);
        for (String resource : List.of(WEB_CSS_PATH, WEB_HTML_PATH, WEB_MARKED_PATH, WEB_SCRIPT_PATH)) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = activator.getResource(resource);){
                if (is == null) {
                    log.error((Object)("Resource not found: " + resource));
                    continue;
                }
                Path path = this.directory.resolve(resource);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                if (resource.equals(WEB_CSS_PATH)) {
                    String cssContent = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    cssContent = this.updateCss(cssContent);
                    Files.writeString(path, (CharSequence)cssContent, new OpenOption[0]);
                    continue;
                }
                Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @NotNull
    public String getWebHtmlPath() {
        return this.directory.resolve(WEB_HTML_PATH).toUri().toString();
    }

    @NotNull
    private String updateCss(@NotNull String cssContent) {
        Map<String, String> values = this.fillValues();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            cssContent = cssContent.replace(entry.getKey(), entry.getValue());
        }
        return cssContent;
    }

    @NotNull
    private Map<String, String> fillValues() {
        ColorRegistry registry = UIUtils.getColorRegistry();
        String promptBackground = this.colorToHex(registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.prompt.background"));
        String promptBorder = this.colorToHex(registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.prompt.border"));
        String waningBackground = this.colorToHex(BaseThemeSettings.instance.colorWarning);
        String errorBackground = this.colorToHex(BaseThemeSettings.instance.colorError);
        String chatBackground = this.colorToHex(UIStyles.getDefaultTextBackground());
        String chatInactiveBackground = this.colorToHex(UIStyles.getDefaultWidgetBackground());
        String textColor = this.colorToHex(registry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        String themeSchema = UIStyles.isDarkTheme() ? "dark" : "light";
        String hyperLinkColor = this.colorToHex(registry.get("HYPERLINK_COLOR"));
        FontData[] mainFont = BaseThemeSettings.instance.baseFont.getFontData();
        String fontSize = WebCSSInitializer.getFontSize(mainFont);
        String fontFamily = WebCSSInitializer.getFontFamily(mainFont, "Arial");
        FontData[] monoFont = BaseThemeSettings.instance.monospaceFont.getFontData();
        String monoFontSize = WebCSSInitializer.getFontSize(monoFont);
        String monoFontFamily = WebCSSInitializer.getFontFamily(monoFont, "monospace");
        return Map.ofEntries(Map.entry("{{BACKGROUND_COLOR}}", chatBackground), Map.entry("{{BACKGROUND_COLOR_INACTIVE}}", chatInactiveBackground), Map.entry("{{TEXT_COLOR}}", textColor), Map.entry("{{PROMPT_BACKGROUND}}", promptBackground), Map.entry("{{PROMPT_BORDER}}", promptBorder), Map.entry("{{WARNING_BACKGROUND}}", waningBackground), Map.entry("{{ERROR_BACKGROUND}}", errorBackground), Map.entry("{{FONT_SIZE}}", fontSize), Map.entry("{{FONT_FAMILY}}", fontFamily), Map.entry("{{MONOSPACE_FONT_SIZE}}", monoFontSize), Map.entry("{{MONOSPACE_FONT_FAMILY}}", monoFontFamily), Map.entry("{{HYPERLINK_COLOR}}", hyperLinkColor), Map.entry("{{COLOR_SCHEME}}", themeSchema));
    }

    @NotNull
    private static String getFontSize(@NotNull FontData[] mainFont) {
        String unit = RuntimeUtils.isMacOS() ? "px" : "pt";
        int height = mainFont.length > 0 ? mainFont[0].getHeight() : 13;
        return height + unit;
    }

    @NotNull
    private static String getFontFamily(@NotNull FontData[] mainFont, @NotNull String defaultFamily) {
        String fontFamily = defaultFamily;
        if (mainFont.length > 0 && (fontFamily = mainFont[0].getName()).equals(".AppleSystemUIFont")) {
            fontFamily = "system-ui";
        }
        return fontFamily;
    }

    @NotNull
    private String colorToHex(@Nullable Color color) {
        if (color == null) {
            return "#000000";
        }
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }
}

