/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.audio.AIAudioRecorder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Flow;
import javax.sound.sampled.AudioFormat;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIStyles;

public class AudioHistogram
implements Flow.Subscriber<ByteBuffer> {
    private static final int BAR_WIDTH = 2;
    private static final int BAR_GAP = 2;
    private static final float GAIN = 40.0f;
    private static final long REDRAW_INTERVAL_NS = Duration.ofMillis(80L).toNanos();
    private static final double WINDOW_SEC = 5.0;
    private final Canvas canvas;
    private final AudioFormat format;
    private final ByteOrder byteOrder;
    private final int maxTicks;
    private final ByteBuffer tail = ByteBuffer.allocate(16384);
    private final Deque<Float> levels = new ArrayDeque<Float>();
    private Flow.Subscription sub;
    private volatile long lastRedrawNs = 0L;
    private double barSec;

    public AudioHistogram(@NotNull Canvas canvas, AudioFormat format) {
        this.canvas = canvas;
        this.format = format;
        this.maxTicks = (int)((double)(format.getFrameRate() / (float)format.getFrameSize()) * 5.0);
        this.byteOrder = format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.canvas.addPaintListener(e -> this.paint(e.gc));
    }

    @Override
    public void onSubscribe(@NotNull Flow.Subscription subscription) {
        this.sub = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@NotNull ByteBuffer frame) {
        if (frame == AIAudioRecorder.RESET_SIGNAL) {
            this.tail.clear();
            Deque<Float> deque = this.levels;
            synchronized (deque) {
                this.levels.clear();
            }
            this.sub.request(1L);
            return;
        }
        ByteBuffer b = frame.duplicate().order(this.byteOrder);
        this.calculateLevelByRms(b);
        this.asyncRedraw();
        this.sub.request(Long.MAX_VALUE);
    }

    @Override
    public void onError(@NotNull Throwable throwable) {
    }

    @Override
    public void onComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(@NotNull GC gc) {
        Float[] snapshot;
        Deque<Float> deque = this.levels;
        synchronized (deque) {
            snapshot = this.levels.toArray(new Float[0]);
        }
        if (snapshot.length == 0) {
            return;
        }
        Rectangle rect = this.canvas.getClientArea();
        gc.setBackground(UIStyles.getDefaultWidgetBackground());
        gc.fillRectangle(rect);
        int barsOnScreen = Math.max(1, rect.width / 4);
        gc.setForeground(UIStyles.getDefaultWidgetBackground());
        gc.setBackground(UIStyles.getDefaultTextSelectionForeground());
        int x = rect.width - 2;
        int i = snapshot.length - 1;
        while (i >= 0 && snapshot.length - 1 - i < barsOnScreen) {
            float lvl = snapshot[i].floatValue();
            float scaled = Math.min(lvl * 40.0f, 1.0f);
            int h = Math.max(1, (int)(scaled * (float)rect.height));
            gc.fillRectangle(x, rect.height - h, 2, h);
            if ((x -= 4) + 2 <= 0) break;
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateLevelByRms(@NotNull ByteBuffer in) {
        int incoming = in.remaining();
        if (incoming <= 0) {
            return;
        }
        if (this.barSec <= 0.0) {
            this.tail.put(in);
            return;
        }
        int framesPerBar = Math.max(1, (int)Math.ceil(this.barSec * (double)Math.max(1.0f, this.format.getFrameRate())));
        int bytesPerBar = Math.max(1, framesPerBar * Math.max(1, this.format.getFrameSize()));
        this.tail.put(in);
        this.tail.flip();
        Deque<Float> deque = this.levels;
        synchronized (deque) {
            while (this.tail.remaining() >= bytesPerBar) {
                ByteBuffer window = this.tail.slice();
                window.limit(bytesPerBar);
                window.order(this.byteOrder);
                this.levels.addLast(Float.valueOf(AudioHistogram.computeRms(window)));
                if (this.levels.size() > this.maxTicks) {
                    this.levels.removeFirst();
                }
                this.tail.position(this.tail.position() + bytesPerBar);
            }
        }
        this.tail.compact();
    }

    private static float computeRms(@NotNull ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return 0.0f;
        }
        long acc = 0L;
        int samples = 0;
        while (buf.hasRemaining()) {
            short sample = buf.getShort();
            acc += (long)sample * (long)sample;
            ++samples;
        }
        if (samples == 0) {
            return 0.0f;
        }
        double rms = Math.sqrt((double)acc / (double)samples);
        return Math.clamp((float)(rms / 32768.0), 0.0f, 1.0f);
    }

    private void asyncRedraw() {
        if (this.canvas.isDisposed()) {
            return;
        }
        long now = System.nanoTime();
        if (now - this.lastRedrawNs < REDRAW_INTERVAL_NS) {
            return;
        }
        this.lastRedrawNs = now;
        this.canvas.getDisplay().asyncExec(() -> {
            if (!this.canvas.isDisposed()) {
                this.barSec = 5.0 / (double)Math.max(1, this.canvas.getClientArea().width / 4);
                this.canvas.redraw();
            }
        });
    }
}

