/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.multi;

import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceScannerFactory;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.api.FFJdbcDriver;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.csv.CsvJdbcDriver;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.json.JsonJdbcDriver;
import com.dbeaver.jdbc.files.multi.MultiSourceDataSourceScanner;
import com.dbeaver.jdbc.files.multi.MultiSourceDatabaseMetaData;
import com.dbeaver.jdbc.files.multi.MultiSourceFileScanner;
import com.dbeaver.jdbc.files.multi.MultiSourceProperties;
import com.dbeaver.jdbc.files.parquet.ParquetJdbcDriver;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import com.dbeaver.jdbc.files.xlsx.XlsxJdbcDriver;
import com.dbeaver.jdbc.files.xml.XmlJdbcDriver;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;

public class MultiSourceJdbcDriver
extends FFJdbcDriver<Object, FFTableProperties, MultiSourceProperties> {
    public static final String DRIVER_NAME = "DBeaver MultiSource File JDBC Driver";
    public static final String DRIVER_PREFIX = "jdbc:dbeaver:file:multi:";
    public static final int DRIVER_VERSION_MAJOR = 1;
    public static final int DRIVER_VERSION_MINOR = 0;
    static final List<FFJdbcDriver<?, ?, ?>> DELEGATE_DRIVERS = List.of(new CsvJdbcDriver(), new ParquetJdbcDriver(), new XlsxJdbcDriver(), new JsonJdbcDriver(), new XmlJdbcDriver());

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new MultiSourceJdbcDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver", e);
        }
    }

    public MultiSourceJdbcDriver() {
        super(DRIVER_PREFIX, 1, 0);
    }

    @NotNull
    protected FFDatabaseMetaData createDatabaseMetaData(@NotNull FFConnection connection, @NotNull String url, @NotNull FFDatabase database) {
        return new MultiSourceDatabaseMetaData(connection, url, database, this.getPropertiesFactory());
    }

    @NotNull
    public FFDataSourceFormat getSupportedDataSourceFormat() {
        throw new UnsupportedOperationException("Should not be called for universal driver");
    }

    @NotNull
    public FFFileScannerFactory<Object, FFTableProperties, MultiSourceProperties> getFileScannerFactory() {
        throw new UnsupportedOperationException("Should not be called for universal driver");
    }

    @NotNull
    public FFDataSourceScannerFactory<Object, FFTableProperties, MultiSourceProperties> getDataSourceScannerFactory() {
        return new FFDataSourceScannerFactory<Object, FFTableProperties, MultiSourceProperties>(){

            @NotNull
            public FFDataSourceScanner<Object, FFTableProperties, MultiSourceProperties> createDataSourceScanner(@NotNull FFDataSource<MultiSourceProperties> dataSource, @NotNull CompletableFuture<Void> connectionClosedFuture) {
                MultiSourceDataSourceScanner dataSourceScanner = new MultiSourceDataSourceScanner();
                for (FFJdbcDriver<?, ?, ?> driver : DELEGATE_DRIVERS) {
                    FFDataSourceFormat format = driver.getSupportedDataSourceFormat();
                    FFDataSource adaptedDatasource = new FFDataSource(dataSource.path(), ((MultiSourceProperties)dataSource.properties()).getPropertiesForFormat(format));
                    FFFileScannerFactory fileScannerFactory = driver.getFileScannerFactory();
                    MultiSourceFileScanner proxyScanner = new MultiSourceFileScanner((FFDataSource<FFProperties>)adaptedDatasource, (FFFileScannerFactory<Object, FFTableProperties, FFProperties>)fileScannerFactory, connectionClosedFuture);
                    dataSourceScanner.addScanner(format, FFIOUtils.getPathMatcher((FFDataSource)adaptedDatasource), proxyScanner);
                }
                return dataSourceScanner;
            }
        };
    }

    @NotNull
    public FFPropertiesFactory<MultiSourceProperties> getPropertiesFactory() {
        return new FFPropertiesFactory<MultiSourceProperties>(){

            public MultiSourceProperties createProperties(Properties properties) {
                return new MultiSourceProperties(properties);
            }

            public MultiSourceProperties createProperties(Map<String, String> properties) {
                return new MultiSourceProperties(properties);
            }
        };
    }

    public String getDriverIdentifier() {
        return DRIVER_NAME;
    }
}

