/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neptune.ui.views;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class AWSNeptuneConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private final Image logoImage = this.createImage("icons/neptune_logo.png");
    private Text hostText;
    private Text portText;

    public Image getImage() {
        return this.logoImage;
    }

    public void createControl(Composite parent) {
        ModifyListener cfr_ignored_0 = e -> this.site.updateButtons();
        Composite configGroup = new Composite(parent, 0);
        configGroup.setLayout((Layout)new GridLayout(1, false));
        configGroup.setLayoutData((Object)new GridData(1808));
        Group settingsGroup = UIUtils.createControlGroup((Composite)configGroup, (String)"Settings", (int)4, (int)768, (int)0);
        this.hostText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Host name", null, (int)2048);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.portText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Port", null, (int)2048);
        UIUtils.setDefaultTextControlWidthHint((Control)this.portText);
        this.createAuthPanel(configGroup, 1);
        this.createDriverPanel(configGroup);
        this.setControl((Control)configGroup);
    }

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    public boolean isComplete() {
        return super.isComplete() && !this.hostText.getText().isEmpty();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        dataSource.getConnectionConfiguration().setHostName(this.hostText.getText());
        dataSource.getConnectionConfiguration().setHostPort(this.portText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        this.hostText.setText((String)CommonUtils.notNull((Object)dataSource.getConnectionConfiguration().getHostName(), (Object)((String)CommonUtils.notNull((Object)dataSource.getDriver().getDefaultHost(), (Object)""))));
        this.portText.setText((String)CommonUtils.notNull((Object)dataSource.getConnectionConfiguration().getHostPort(), (Object)((String)CommonUtils.notNull((Object)dataSource.getDriver().getDefaultPort(), (Object)"8192"))));
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

