/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.ui;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.AzureCloudProvider;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.ui.provider.BaseCloudConfigurationEditor;
import com.dbeaver.net.auth.azure.AuthModelAzureAbstract;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import com.dbeaver.ui.auth.azure.AuthModelAzureConfigurator;
import java.util.LinkedHashMap;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AzureCloudConfigurationEditor
extends BaseCloudConfigurationEditor<AzureCloud, AzureCloudConfiguration, AuthModelAzureConfigurator> {
    private Text storageAccountText;
    private Text storageAccountKeyText;

    protected AuthModelAzureConfigurator createAuthConfigurator(Composite parent, Runnable propertyChangeListener) {
        AuthModelAzureConfigurator configurator = new AuthModelAzureConfigurator();
        Group authGroup = UIUtils.createControlGroup((Composite)parent, (String)"Authentication", (int)2, (int)768, (int)-1);
        configurator.createControl((Composite)authGroup, null, propertyChangeListener);
        this.createStorageAccountControls(parent);
        return configurator;
    }

    protected AzureCloud createCloudFromConfiguration(AzureCloudConfiguration configuration) {
        return AzureCloudProvider.getInstance().createCloudFromConfiguration((CPCloudConfiguration)configuration);
    }

    protected boolean isSessionOpen(AuthModelAzureConfigurator configurator, AzureCloudConfiguration curConfiguration) {
        return true;
    }

    public void createGeneralTab(CTabFolder parent, Runnable propertyChangeListener) {
        super.createGeneralTab(parent, propertyChangeListener);
    }

    public void loadSettings(@NotNull AzureCloudConfiguration configuration) {
        super.loadSettings((CPCloudConfiguration)configuration);
        this.mainGroup.setRedraw(false);
        try {
            LinkedHashMap authProperties = new LinkedHashMap();
            AuthModelAzureAbstract.saveCredentialsToMap((AuthModelAzureCredentials)configuration.getDefaultCredentials(), authProperties);
            AuthModelAzureConfigurator dsConfigurator = (AuthModelAzureConfigurator)this.getDataSourceConfigurator();
            dsConfigurator.loadGeneralAuthSettings(((AzureCloudConfiguration)this.getCurConfiguration()).isDefaultConfiguration(), authProperties);
            dsConfigurator.updateControls();
        }
        finally {
            this.mainGroup.setRedraw(true);
        }
        this.storageAccountText.setText(CommonUtils.notEmpty((String)configuration.getStorageAccountId()));
        this.storageAccountKeyText.setText(CommonUtils.notEmpty((String)configuration.getStorageAccountKey()));
        this.updateSessionActions();
    }

    protected boolean isDefaultConfigurationEditable() {
        return true;
    }

    public void saveSettings(@NotNull AzureCloudConfiguration configuration) {
        super.saveSettings((CPCloudConfiguration)configuration);
        LinkedHashMap authProperties = new LinkedHashMap();
        ((AuthModelAzureConfigurator)this.getDataSourceConfigurator()).saveGeneralAuthSettings(authProperties);
        AuthModelAzureAbstract.loadCredentialsFromMap((AuthModelAzureCredentials)configuration.getDefaultCredentials(), authProperties);
        String saID = this.storageAccountText.getText();
        String saKey = this.storageAccountKeyText.getText();
        configuration.setStorageAccountId(CommonUtils.isEmpty((String)saID) ? null : saID);
        configuration.setStorageAccountKey(CommonUtils.isEmpty((String)saKey) ? null : saKey);
    }

    public boolean isComplete() {
        return super.isComplete();
    }

    protected void createExtraTabs(CTabFolder configTabs, Runnable propertyChangeListener) {
    }

    private void createStorageAccountTab(TabFolder configTabs, Runnable propertyChangeListener) {
        Composite saGroup = this.createStorageAccountControls((Composite)configTabs);
        TabItem regionsTab = new TabItem(configTabs, 0);
        regionsTab.setText("Storage account");
        regionsTab.setControl((Control)saGroup);
    }

    @NotNull
    private Composite createStorageAccountControls(Composite configTabs) {
        Group saGroup = UIUtils.createControlGroup((Composite)configTabs, (String)"Storage account", (int)2, (int)768, (int)-1);
        GridLayout gd = new GridLayout(2, false);
        Layout layout = configTabs.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gl = (GridLayout)layout;
            ((GridData)saGroup.getLayoutData()).horizontalSpan = gl.numColumns;
        }
        saGroup.setLayout((Layout)gd);
        UIUtils.createInfoLabel((Composite)saGroup, (String)"Storage account is required for Azure Storage usage", (int)768, (int)2);
        this.storageAccountText = UIUtils.createLabelText((Composite)saGroup, (String)"Account ID", null);
        this.storageAccountText.setMessage("Storage account ID");
        this.storageAccountKeyText = UIUtils.createLabelText((Composite)saGroup, (String)"Access Key", null, (int)0x400800);
        this.storageAccountKeyText.setMessage("Storage account access key");
        return saGroup;
    }
}

