/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.DataExporterSQL;

public class SampleDataProvider {
    private static final Log log = Log.getLog(SampleDataProvider.class);
    private static final Set<JDBCType> EXCLUSIONS = Set.of(JDBCType.ARRAY, JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.LONGVARBINARY, JDBCType.BLOB, JDBCType.CLOB, JDBCType.NCLOB, JDBCType.SQLXML);
    private final Map<String, String> tablesData = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> tablesChecksum = new ConcurrentHashMap<String, Long>();

    public String getSampleData(DBRProgressMonitor monitor, DBSDataContainer dataContainer, int rowCount) throws DBException {
        Long previous;
        String tableName = dataContainer.getName();
        long checksum = 0L;
        if (dataContainer instanceof DBSEntity) {
            DBSEntity entity = (DBSEntity)dataContainer;
            checksum = SampleDataProvider.computeChecksum(entity, monitor);
        }
        if ((previous = this.tablesChecksum.get(tableName)) == null || previous != checksum) {
            String sampleData = SampleDataProvider.fetchSampleData(monitor, dataContainer, rowCount);
            this.tablesData.put(tableName, sampleData);
            this.tablesChecksum.put(tableName, checksum);
            return sampleData;
        }
        return this.tablesData.get(tableName);
    }

    private static String fetchSampleData(DBRProgressMonitor monitor, DBSDataContainer dataContainer, int rowCount) throws DBException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (SampleDataCollector dataReceiver = new SampleDataCollector(dataContainer);){
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataContainer.getDataSource(), param -> {
                Throwable throwable = null;
                Object var6_7 = null;
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)dataContainer, (String)"Fetch sample data");){
                    dataContainer.readData(null, session, (DBDDataReceiver)dataReceiver, null, 0L, (long)rowCount, 0L, 100);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
            return dataReceiver.getSampleData();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static long computeChecksum(DBSEntity entity, DBRProgressMonitor monitor) throws DBException {
        List attributes = entity.getAttributes(monitor);
        if (attributes == null || attributes.isEmpty()) {
            return 0L;
        }
        CRC32 crc32 = new CRC32();
        for (DBSEntityAttribute attribute : attributes) {
            if (DBUtils.isHiddenObject((Object)attribute)) continue;
            crc32.update(attribute.getName().getBytes(StandardCharsets.UTF_8));
            crc32.update(attribute.getTypeID());
        }
        return crc32.getValue();
    }

    private static class SampleDataCollector
    implements DBDDataReceiver {
        private final DataExporterSQL dataExporter = new DataExporterSQL();
        private final StringWriter stringWriter = new StringWriter();
        private final AtomicInteger sampleCount = new AtomicInteger(0);
        private final DBSDataContainer dataContainer;

        public SampleDataCollector(DBSDataContainer dataContainer) {
            this.dataContainer = dataContainer;
        }

        public String getSampleData() {
            if (this.sampleCount.get() <= 0) {
                return "";
            }
            return this.stringWriter.toString();
        }

        public void fetchStart(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            List attributes = resultSet.getMeta().getAttributes();
            DBDAttributeBinding[] attributeBindings = (DBDAttributeBinding[])attributes.stream().map(it -> new DBDAttributeBindingMeta(this.dataContainer, session, it)).toArray(DBDAttributeBinding[]::new);
            try {
                this.dataExporter.init((IStreamDataExporterSite)new SampleDataExporterSite((DBPNamedObject)this.dataContainer, attributeBindings, new PrintWriter((Writer)this.stringWriter, true)));
                this.dataExporter.exportHeader(session);
            }
            catch (Exception e) {
                log.error((Object)"Error initializing data exporter", (Throwable)e);
                throw new DBCException("Error initializing data exporter", (Throwable)e);
            }
        }

        public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
            try {
                List attributes = resultSet.getMeta().getAttributes();
                Object[] row = new Object[attributes.size()];
                boolean shouldBeSkipped = true;
                int i = 0;
                while (i < attributes.size()) {
                    DBCAttributeMetaData attr = (DBCAttributeMetaData)attributes.get(i);
                    JDBCType type = JDBCType.valueOf(attr.getTypeID());
                    if (EXCLUSIONS.contains(type)) {
                        row[i] = null;
                    } else {
                        row[i] = resultSet.getAttributeValue(attr.getName());
                        shouldBeSkipped = false;
                    }
                    ++i;
                }
                if (shouldBeSkipped) {
                    return;
                }
                this.sampleCount.incrementAndGet();
                this.dataExporter.exportRow(session, resultSet, row);
            }
            catch (Exception e) {
                log.error((Object)"Error exporting row", (Throwable)e);
                throw new DBCException("Error exporting row", (Throwable)e);
            }
        }

        public void fetchEnd(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
            this.dataExporter.exportFooter(session.getProgressMonitor());
        }

        public void close() {
            this.dataExporter.dispose();
        }
    }

    private static class SampleDataExporterSite
    implements IStreamDataExporterSite {
        private final DBPNamedObject source;
        private final DBDAttributeBinding[] attributes;
        private final PrintWriter writer;

        private SampleDataExporterSite(DBPNamedObject source, DBDAttributeBinding[] attributes, PrintWriter writer) {
            this.source = source;
            this.attributes = attributes;
            this.writer = writer;
        }

        public DBPNamedObject getSource() {
            return this.source;
        }

        public DBDDisplayFormat getExportFormat() {
            return DBDDisplayFormat.NATIVE;
        }

        public Map<String, Object> getProperties() {
            return Map.of("identifierCase", "as is", "rowsInStatement", 10, "nativeFormat", true);
        }

        public DBDAttributeBinding[] getAttributes() {
            return this.attributes;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        @Nullable
        public Path getOutputFile() {
            return null;
        }

        public PrintWriter getWriter() {
            return this.writer;
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void writeBinaryData(@NotNull DBDContentStorage cs) throws IOException {
        }

        @NotNull
        public String getOutputEncoding() {
            return StandardCharsets.UTF_8.displayName();
        }
    }
}

