/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.anthropic;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;

public class AnthropicModels {
    public static final String DEFAULT_MODEL = "claude-opus-4-1-20250805";
    public static final Map<String, AIModel> KNOWN_MODELS = Stream.of(new AIModel("claude-opus-4-1-20250805", Integer.valueOf(200000), Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("claude-opus-4-20250514", Integer.valueOf(200000), Set.of(AIModelFeature.CHAT)), new AIModel("claude-sonnet-4-20250514", Integer.valueOf(200000), Set.of(AIModelFeature.CHAT), 1.0), new AIModel("claude-3-7-sonnet-20250219", Integer.valueOf(200000), Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING), 1.0), new AIModel("claude-3-5-haiku-20241022", Integer.valueOf(200000), Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("claude-3-haiku-20240307", Integer.valueOf(200000), Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING))).collect(Collectors.toMap(AIModel::name, Function.identity()));
    private static final Set<String> DEPRECATED_MODELS = Set.of("claude-3-opus-20240229", "claude-3-5-sonnet-20240620", "claude-3-5-sonnet-20241022");

    private AnthropicModels() {
    }

    @NotNull
    public static String getEffectiveModelName(@Nullable String modelName) {
        if (modelName == null || modelName.isEmpty()) {
            return DEFAULT_MODEL;
        }
        String lowerCaseModelName = modelName.toLowerCase(Locale.ROOT);
        if (KNOWN_MODELS.containsKey(lowerCaseModelName)) {
            return lowerCaseModelName;
        }
        if (DEPRECATED_MODELS.contains(lowerCaseModelName)) {
            return DEFAULT_MODEL;
        }
        return lowerCaseModelName;
    }

    @NotNull
    public static Optional<AIModel> getModelByName(@Nullable String modelName) {
        if (modelName == null || modelName.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(KNOWN_MODELS.get(modelName.toLowerCase(Locale.ROOT)));
    }

    public static Set<AIModelFeature> detectModelFeatures(@NotNull String modelName) {
        AIModel knownModel = KNOWN_MODELS.get(modelName.toLowerCase(Locale.ROOT));
        if (knownModel != null) {
            return knownModel.features();
        }
        HashSet<AIModelFeature> features = new HashSet<AIModelFeature>();
        features.add(AIModelFeature.CHAT);
        features.add(AIModelFeature.STREAMING);
        return features;
    }
}

