/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatSession;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class AIChatConversationSettings
extends AIContextSettings {
    private final AIChatSession session;
    private final AIChatConversation conversation;

    public AIChatConversationSettings(@NotNull AIChatSession session, @NotNull AIChatConversation conversation) {
        this.session = session;
        this.conversation = conversation;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.conversation.getDataSource();
    }

    public void saveSettings() throws DBException {
        AICompletionSettings dsSettings;
        DBPDataSourceContainer dataSource = this.conversation.getDataSource();
        if (dataSource != null && (dsSettings = new AICompletionSettings(dataSource)).isMetaTransferConfirmed() != this.isMetaTransferConfirmed()) {
            dsSettings.setMetaTransferConfirmed(this.isMetaTransferConfirmed());
            dsSettings.saveSettings();
        }
        this.session.saveConversationSettings((DBRProgressMonitor)new VoidProgressMonitor(), this.conversation);
    }

    public void loadDataSourceDefaults() {
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer != null) {
            AICompletionSettings dsSettings = new AICompletionSettings(dataSourceContainer);
            this.setMetaTransferConfirmed(dsSettings.isMetaTransferConfirmed());
        }
    }
}

