/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisResultSetSimple;
import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisDatabase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class RedisCommandStatement
extends RedisBaseStatement {
    protected Object result;
    private final String[] command;

    public RedisCommandStatement(RedisSession session, String[] command) {
        super(session, String.join((CharSequence)" ", command), 0L, 0L);
        this.command = command;
    }

    public boolean executeStatement() throws DBCException {
        if (((RedisSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            RedisUtils.selectCurDatabase((RedisSession)this.getSession());
            String commandName = this.command[0];
            String[] commandArguments = new String[this.command.length - 1];
            System.arraycopy(this.command, 1, commandArguments, 0, this.command.length - 1);
            UnifiedJedis jedisClient = ((RedisSession)this.getSession()).getJedisClient();
            this.result = RedisCommandStatement.executeCommand(jedisClient, commandName, commandArguments);
            if ("select".equalsIgnoreCase(commandName) && commandArguments.length == 1) {
                int defDatabase = CommonUtils.toInt((Object)commandArguments[0]);
                RedisDatabase database = ((RedisSession)this.getSession()).getDataSource().getDatabase(defDatabase);
                if (database == null) {
                    database = ((RedisSession)this.getSession()).getDataSource().addDatabase(defDatabase);
                }
                if (database != null) {
                    ((RedisSession)this.getSession()).getExecutionContext().setDefaultCatalog(((RedisSession)this.getSession()).getProgressMonitor(), database, (DBSSchema)null);
                }
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (((RedisSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public static Object executeCommand(Object jedisClient, String commandName, String ... commandArguments) throws DBCException {
        ProtocolCommand pc = () -> SafeEncoder.encode((String)commandName);
        if (jedisClient instanceof UnifiedJedis) {
            int i = 0;
            while (i < commandArguments.length) {
                String script = commandArguments[i];
                if (script.length() > 2 && (script.charAt(0) == '\"' || script.charAt(0) == '\'') && script.charAt(0) == script.charAt(script.length() - 1)) {
                    commandArguments[i] = script = script.substring(1, script.length() - 1);
                }
                ++i;
            }
            return ((UnifiedJedis)jedisClient).sendCommand(pc, commandArguments);
        }
        throw new DBCException("Unsupported Redis client: " + String.valueOf(jedisClient));
    }

    private Object evaluateCommand(String[] command, Object jedis) throws DBCException {
        String commandName = command[0].toLowerCase(Locale.ENGLISH);
        Method[] methods = ((RedisSession)this.getSession()).getDataSource().getCommandMethods(commandName);
        if (methods == null) {
            throw new DBCException("Unrecognized command [" + commandName + "]");
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == command.length - 1) {
                Object[] params = new Object[paramTypes.length];
                boolean hasBadParams = false;
                try {
                    int i = 0;
                    while (i < paramTypes.length) {
                        Class<?> paramType = paramTypes[i];
                        if (paramType.isPrimitive() || BeanUtils.isNumericType(paramType) || BeanUtils.isBooleanType(paramType) || paramType == String.class) {
                            params[i] = GeneralUtils.convertString((String)command[1 + i], paramType);
                        } else {
                            if (Map.class.isAssignableFrom(paramType)) {
                                hasBadParams = true;
                                break;
                            }
                            if (paramType.isArray() && paramType.getComponentType() == String.class) {
                                params[i] = new String[]{command[1 + i]};
                            }
                        }
                        ++i;
                    }
                    if (!hasBadParams) {
                        return method.invoke(jedis, params);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)((RedisSession)this.getSession()).getExecutionContext());
                }
                catch (InvocationTargetException e) {
                    throw new DBCException(e.getTargetException(), (DBCExecutionContext)((RedisSession)this.getSession()).getExecutionContext());
                }
            }
            ++n2;
        }
        throw new DBCException("Can't find appropriate method for command '" + commandName + "' (" + (command.length - 1) + ")");
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, (int)this.offset);
    }
}

