/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.security.cyberark;

import com.dbeaver.model.cyberark.CyberArkParametersProviderConfiguration;
import com.dbeaver.ui.internal.UICoreMessages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class CyberArkParametersProviderConfigurator
implements IObjectPropertyConfigurator<CyberArkParametersProviderConfiguration, CyberArkParametersProviderConfiguration> {
    private Text serverUrlText;
    private Text accountText;
    private Text usernameText;
    private Text apiKeyText;
    private Text policyBranchText;
    private Button trustCert;
    private Button isGlobalCheckbox;

    public void createControl(@NotNull Composite parent, CyberArkParametersProviderConfiguration object, @NotNull Runnable propertyChangeListener) {
        this.serverUrlText = UIUtils.createLabelText((Composite)parent, (String)UICoreMessages.cyberark_server_url_label, (String)CommonUtils.notEmpty((String)object.getBaseUrl()), (int)2048);
        this.accountText = UIUtils.createLabelText((Composite)parent, (String)UICoreMessages.cyberark_account_label, (String)CommonUtils.notEmpty((String)object.getAccount()), (int)2048);
        this.usernameText = UIUtils.createLabelText((Composite)parent, (String)UICoreMessages.cyberark_username_label, (String)CommonUtils.notEmpty((String)object.getUsername()), (int)2048);
        this.apiKeyText = UIUtils.createLabelText((Composite)parent, (String)UICoreMessages.cyberark_api_key_label, (String)CommonUtils.notEmpty((String)object.getApiKey()), (int)0x400800);
        this.policyBranchText = UIUtils.createLabelText((Composite)parent, (String)UICoreMessages.cyberark_policy_branch_label, (String)CommonUtils.notEmpty((String)object.getPolicyBranch()), (int)2048);
        this.trustCert = UIUtils.createCheckbox((Composite)parent, (String)UICoreMessages.cyberark_trust_certificate_label, (boolean)object.isTrustCertificate());
        if (DBWorkbench.getPlatform().getApplication().isDistributed()) {
            this.isGlobalCheckbox = UIUtils.createCheckbox((Composite)parent, (String)UICoreMessages.cyberark_global_configuration_label, (boolean)object.isGlobalConfiguration());
        }
    }

    public void loadSettings(@NotNull CyberArkParametersProviderConfiguration config) {
        this.serverUrlText.setText(CommonUtils.notEmpty((String)config.getBaseUrl()));
        this.accountText.setText(CommonUtils.notEmpty((String)config.getAccount()));
        this.usernameText.setText(CommonUtils.notEmpty((String)config.getUsername()));
        this.apiKeyText.setText(CommonUtils.notEmpty((String)config.getApiKey()));
        this.policyBranchText.setText(CommonUtils.notEmpty((String)config.getPolicyBranch()));
        this.trustCert.setSelection(config.isTrustCertificate());
        if (this.isGlobalCheckbox != null) {
            this.isGlobalCheckbox.setSelection(config.isGlobalConfiguration());
        }
    }

    public void saveSettings(@NotNull CyberArkParametersProviderConfiguration config) {
        config.setBaseUrl(this.serverUrlText.getText());
        config.setAccount(this.accountText.getText());
        config.setUsername(this.usernameText.getText());
        config.setApiKey(this.apiKeyText.getText());
        config.setPolicyBranch(this.policyBranchText.getText());
        config.setTrustCertificate(this.trustCert.getSelection());
        if (this.isGlobalCheckbox != null) {
            config.setGlobalConfiguration(this.isGlobalCheckbox.getSelection());
        }
    }

    public void resetSettings(@NotNull CyberArkParametersProviderConfiguration config) {
    }

    public boolean isComplete() {
        return CommonUtils.isNotEmpty((String)this.serverUrlText.getText()) && CommonUtils.isNotEmpty((String)this.accountText.getText()) && CommonUtils.isNotEmpty((String)this.usernameText.getText()) && CommonUtils.isNotEmpty((String)this.apiKeyText.getText()) && CommonUtils.isNotEmpty((String)this.policyBranchText.getText());
    }
}

