/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences.secrets;

import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderDescriptor;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

class EditConfigurationDialog
extends BaseDialog {
    private final DBPParametersProviderDescriptor provider;
    private final DBPParametersConfiguration configuration;
    private Text nameText;
    private IObjectPropertyConfigurator<DBPParametersConfiguration, DBPParametersConfiguration> configurator;

    public EditConfigurationDialog(@NotNull Shell parentShell, @NotNull DBPParametersProviderDescriptor provider, @NotNull DBPParametersConfiguration configuration) {
        super(parentShell, "Edit secret configuration", null);
        this.provider = provider;
        this.configuration = configuration;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        Text providerText = UIUtils.createLabelText((Composite)composite, (String)"Provider", (String)(this.provider.getLabel() + " (" + this.provider.getId() + ")"), (int)2048);
        providerText.setEditable(false);
        this.nameText = UIUtils.createLabelText((Composite)composite, (String)"Name", (String)CommonUtils.notEmpty((String)this.configuration.getConfigurationName()));
        this.nameText.addModifyListener(e -> this.updateButtons());
        this.updateButtons();
        this.nameText.setFocus();
        UIPropertyConfiguratorDescriptor uiCfgDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor((Object)this.configuration);
        if (uiCfgDescriptor != null) {
            try {
                this.configurator = uiCfgDescriptor.createConfigurator();
                this.configurator.createControl(composite, (Object)this.configuration, () -> {});
                this.configurator.loadSettings((Object)this.configuration);
            }
            catch (Exception e2) {
                DBWorkbench.getPlatformUI().showError("Bad UI configurator", "Error creating UI configurator", (Throwable)e2);
            }
        }
        return dialogArea;
    }

    private void updateButtons() {
        this.enableButton(0, !CommonUtils.isEmpty((String)this.nameText.getText()));
    }

    protected void okPressed() {
        if (this.configurator == null) {
            return;
        }
        try {
            if (!this.configurator.isComplete()) {
                throw new DBException("Configuration is incomplete");
            }
            this.configurator.saveSettings((Object)this.configuration);
            this.configuration.setConfigurationName(this.nameText.getText());
            DBPParametersProviderRegistry.getInstance().addOrUpdateConfiguration(this.configuration);
            SMSession workspaceSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
            if (workspaceSession != null) {
                this.provider.getInstance().invalidateCredentials(workspaceSession, this.configuration);
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Save secret configuration", "Error saving configuration", (Throwable)e);
            return;
        }
        super.okPressed();
    }
}

