/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.ui;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.model.license.embedded.LicenseServiceEmbedded;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.eclipse.core.expressions.PropertyTester;

public class LicensePromoPropertyTester
extends PropertyTester {
    public static final String PROP_CAN_SHOW_PROMO = "canShowPromo";

    /*
     * WARNING - void declaration
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        LMLicense license;
        DBPLicenseService dBPLicenseService;
        if (!property.equals(PROP_CAN_SHOW_PROMO) || !((dBPLicenseService = LMAppUtils.getLicenseService()) instanceof LicenseServiceEmbedded)) {
            return false;
        }
        LicenseServiceEmbedded licenseServiceEmbedded = (LicenseServiceEmbedded)dBPLicenseService;
        try {
            void service;
            license = service.getActiveProductLicense(false);
        }
        catch (LMException lMException) {
            return false;
        }
        if (license == null) {
            return false;
        }
        LMLicenseType type = license.getLicenseType();
        if (type == LMLicenseType.TRIAL || type == LMLicenseType.EAP) {
            return true;
        }
        if (license.getLicenseType().isExtendable()) {
            LocalDate then = LocalDate.ofInstant(license.getSupportEndDate().toInstant(), ZoneId.systemDefault());
            LocalDate now = LocalDate.now();
            return now.until(then, ChronoUnit.DAYS) <= 14L;
        }
        return false;
    }
}

