/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdate;

public class DescribeServiceUpdatesPublisher
implements SdkPublisher<DescribeServiceUpdatesResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeServiceUpdatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServiceUpdatesPublisher(ElastiCacheAsyncClient client, DescribeServiceUpdatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServiceUpdatesPublisher(ElastiCacheAsyncClient client, DescribeServiceUpdatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServiceUpdatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServiceUpdatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceUpdate> serviceUpdates() {
        Function<DescribeServiceUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceUpdates() != null) {
                return response.serviceUpdates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeServiceUpdatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeServiceUpdatesResponseFetcher
    implements AsyncPageFetcher<DescribeServiceUpdatesResponse> {
        private DescribeServiceUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServiceUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeServiceUpdatesResponse> nextPage(DescribeServiceUpdatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServiceUpdatesPublisher.this.client.describeServiceUpdates(DescribeServiceUpdatesPublisher.this.firstRequest);
            }
            return DescribeServiceUpdatesPublisher.this.client.describeServiceUpdates((DescribeServiceUpdatesRequest)((Object)DescribeServiceUpdatesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

