/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlobalReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalReplicationGroupIdSuffix").getter(CreateGlobalReplicationGroupRequest.getter(CreateGlobalReplicationGroupRequest::globalReplicationGroupIdSuffix)).setter(CreateGlobalReplicationGroupRequest.setter(Builder::globalReplicationGroupIdSuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupIdSuffix").build()}).build();
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalReplicationGroupDescription").getter(CreateGlobalReplicationGroupRequest.getter(CreateGlobalReplicationGroupRequest::globalReplicationGroupDescription)).setter(CreateGlobalReplicationGroupRequest.setter(Builder::globalReplicationGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupDescription").build()}).build();
    private static final SdkField<String> PRIMARY_REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryReplicationGroupId").getter(CreateGlobalReplicationGroupRequest.getter(CreateGlobalReplicationGroupRequest::primaryReplicationGroupId)).setter(CreateGlobalReplicationGroupRequest.setter(Builder::primaryReplicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryReplicationGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_REPLICATION_GROUP_ID_SUFFIX_FIELD, GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD, PRIMARY_REPLICATION_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGlobalReplicationGroupRequest.memberNameToFieldInitializer();
    private final String globalReplicationGroupIdSuffix;
    private final String globalReplicationGroupDescription;
    private final String primaryReplicationGroupId;

    private CreateGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupIdSuffix = builder.globalReplicationGroupIdSuffix;
        this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
        this.primaryReplicationGroupId = builder.primaryReplicationGroupId;
    }

    public final String globalReplicationGroupIdSuffix() {
        return this.globalReplicationGroupIdSuffix;
    }

    public final String globalReplicationGroupDescription() {
        return this.globalReplicationGroupDescription;
    }

    public final String primaryReplicationGroupId() {
        return this.primaryReplicationGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupIdSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryReplicationGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalReplicationGroupRequest)) {
            return false;
        }
        CreateGlobalReplicationGroupRequest other = (CreateGlobalReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.globalReplicationGroupIdSuffix(), other.globalReplicationGroupIdSuffix()) && Objects.equals(this.globalReplicationGroupDescription(), other.globalReplicationGroupDescription()) && Objects.equals(this.primaryReplicationGroupId(), other.primaryReplicationGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGlobalReplicationGroupRequest").add("GlobalReplicationGroupIdSuffix", (Object)this.globalReplicationGroupIdSuffix()).add("GlobalReplicationGroupDescription", (Object)this.globalReplicationGroupDescription()).add("PrimaryReplicationGroupId", (Object)this.primaryReplicationGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalReplicationGroupIdSuffix": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupIdSuffix()));
            }
            case "GlobalReplicationGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupDescription()));
            }
            case "PrimaryReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.primaryReplicationGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GlobalReplicationGroupIdSuffix", GLOBAL_REPLICATION_GROUP_ID_SUFFIX_FIELD);
        map.put("GlobalReplicationGroupDescription", GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD);
        map.put("PrimaryReplicationGroupId", PRIMARY_REPLICATION_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((CreateGlobalReplicationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String globalReplicationGroupIdSuffix;
        private String globalReplicationGroupDescription;
        private String primaryReplicationGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalReplicationGroupRequest model) {
            super(model);
            this.globalReplicationGroupIdSuffix(model.globalReplicationGroupIdSuffix);
            this.globalReplicationGroupDescription(model.globalReplicationGroupDescription);
            this.primaryReplicationGroupId(model.primaryReplicationGroupId);
        }

        public final String getGlobalReplicationGroupIdSuffix() {
            return this.globalReplicationGroupIdSuffix;
        }

        public final void setGlobalReplicationGroupIdSuffix(String globalReplicationGroupIdSuffix) {
            this.globalReplicationGroupIdSuffix = globalReplicationGroupIdSuffix;
        }

        @Override
        public final Builder globalReplicationGroupIdSuffix(String globalReplicationGroupIdSuffix) {
            this.globalReplicationGroupIdSuffix = globalReplicationGroupIdSuffix;
            return this;
        }

        public final String getGlobalReplicationGroupDescription() {
            return this.globalReplicationGroupDescription;
        }

        public final void setGlobalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
        }

        @Override
        public final Builder globalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        public final String getPrimaryReplicationGroupId() {
            return this.primaryReplicationGroupId;
        }

        public final void setPrimaryReplicationGroupId(String primaryReplicationGroupId) {
            this.primaryReplicationGroupId = primaryReplicationGroupId;
        }

        @Override
        public final Builder primaryReplicationGroupId(String primaryReplicationGroupId) {
            this.primaryReplicationGroupId = primaryReplicationGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalReplicationGroupRequest build() {
            return new CreateGlobalReplicationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGlobalReplicationGroupRequest> {
        public Builder globalReplicationGroupIdSuffix(String var1);

        public Builder globalReplicationGroupDescription(String var1);

        public Builder primaryReplicationGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

