/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheNode;
import software.amazon.awssdk.services.elasticache.model.CacheNodeListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.IpDiscovery;
import software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration;
import software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.NetworkType;
import software.amazon.awssdk.services.elasticache.model.NotificationConfiguration;
import software.amazon.awssdk.services.elasticache.model.PendingModifiedValues;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheCluster> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(CacheCluster.getter(CacheCluster::cacheClusterId)).setter(CacheCluster.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<Endpoint> CONFIGURATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationEndpoint").getter(CacheCluster.getter(CacheCluster::configurationEndpoint)).setter(CacheCluster.setter(Builder::configurationEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_DOWNLOAD_LANDING_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientDownloadLandingPage").getter(CacheCluster.getter(CacheCluster::clientDownloadLandingPage)).setter(CacheCluster.setter(Builder::clientDownloadLandingPage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientDownloadLandingPage").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(CacheCluster.getter(CacheCluster::cacheNodeType)).setter(CacheCluster.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CacheCluster.getter(CacheCluster::engine)).setter(CacheCluster.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CacheCluster.getter(CacheCluster::engineVersion)).setter(CacheCluster.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterStatus").getter(CacheCluster.getter(CacheCluster::cacheClusterStatus)).setter(CacheCluster.setter(Builder::cacheClusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterStatus").build()}).build();
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumCacheNodes").getter(CacheCluster.getter(CacheCluster::numCacheNodes)).setter(CacheCluster.setter(Builder::numCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()}).build();
    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredAvailabilityZone").getter(CacheCluster.getter(CacheCluster::preferredAvailabilityZone)).setter(CacheCluster.setter(Builder::preferredAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build();
    private static final SdkField<String> PREFERRED_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredOutpostArn").getter(CacheCluster.getter(CacheCluster::preferredOutpostArn)).setter(CacheCluster.setter(Builder::preferredOutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build()}).build();
    private static final SdkField<Instant> CACHE_CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CacheClusterCreateTime").getter(CacheCluster.getter(CacheCluster::cacheClusterCreateTime)).setter(CacheCluster.setter(Builder::cacheClusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterCreateTime").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(CacheCluster.getter(CacheCluster::preferredMaintenanceWindow)).setter(CacheCluster.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(CacheCluster.getter(CacheCluster::pendingModifiedValues)).setter(CacheCluster.setter(Builder::pendingModifiedValues)).constructor(PendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(CacheCluster.getter(CacheCluster::notificationConfiguration)).setter(CacheCluster.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final SdkField<List<CacheSecurityGroupMembership>> CACHE_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheSecurityGroups").getter(CacheCluster.getter(CacheCluster::cacheSecurityGroups)).setter(CacheCluster.setter(Builder::cacheSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroups").build(), ListTrait.builder().memberLocationName("CacheSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<CacheParameterGroupStatus> CACHE_PARAMETER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheParameterGroup").getter(CacheCluster.getter(CacheCluster::cacheParameterGroup)).setter(CacheCluster.setter(Builder::cacheParameterGroup)).constructor(CacheParameterGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroup").build()}).build();
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSubnetGroupName").getter(CacheCluster.getter(CacheCluster::cacheSubnetGroupName)).setter(CacheCluster.setter(Builder::cacheSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build()}).build();
    private static final SdkField<List<CacheNode>> CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheNodes").getter(CacheCluster.getter(CacheCluster::cacheNodes)).setter(CacheCluster.setter(Builder::cacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodes").build(), ListTrait.builder().memberLocationName("CacheNode").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNode").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(CacheCluster.getter(CacheCluster::autoMinorVersionUpgrade)).setter(CacheCluster.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<List<SecurityGroupMembership>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(CacheCluster.getter(CacheCluster::securityGroups)).setter(CacheCluster.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(CacheCluster.getter(CacheCluster::replicationGroupId)).setter(CacheCluster.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(CacheCluster.getter(CacheCluster::snapshotRetentionLimit)).setter(CacheCluster.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(CacheCluster.getter(CacheCluster::snapshotWindow)).setter(CacheCluster.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AuthTokenEnabled").getter(CacheCluster.getter(CacheCluster::authTokenEnabled)).setter(CacheCluster.setter(Builder::authTokenEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()}).build();
    private static final SdkField<Instant> AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AuthTokenLastModifiedDate").getter(CacheCluster.getter(CacheCluster::authTokenLastModifiedDate)).setter(CacheCluster.setter(Builder::authTokenLastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenLastModifiedDate").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TransitEncryptionEnabled").getter(CacheCluster.getter(CacheCluster::transitEncryptionEnabled)).setter(CacheCluster.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AtRestEncryptionEnabled").getter(CacheCluster.getter(CacheCluster::atRestEncryptionEnabled)).setter(CacheCluster.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(CacheCluster.getter(CacheCluster::arn)).setter(CacheCluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<Boolean> REPLICATION_GROUP_LOG_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReplicationGroupLogDeliveryEnabled").getter(CacheCluster.getter(CacheCluster::replicationGroupLogDeliveryEnabled)).setter(CacheCluster.setter(Builder::replicationGroupLogDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupLogDeliveryEnabled").build()}).build();
    private static final SdkField<List<LogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogDeliveryConfigurations").getter(CacheCluster.getter(CacheCluster::logDeliveryConfigurations)).setter(CacheCluster.setter(Builder::logDeliveryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(), ListTrait.builder().memberLocationName("LogDeliveryConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfiguration").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CacheCluster.getter(CacheCluster::networkTypeAsString)).setter(CacheCluster.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpDiscovery").getter(CacheCluster.getter(CacheCluster::ipDiscoveryAsString)).setter(CacheCluster.setter(Builder::ipDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()}).build();
    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitEncryptionMode").getter(CacheCluster.getter(CacheCluster::transitEncryptionModeAsString)).setter(CacheCluster.setter(Builder::transitEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, CONFIGURATION_ENDPOINT_FIELD, CLIENT_DOWNLOAD_LANDING_PAGE_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_CLUSTER_STATUS_FIELD, NUM_CACHE_NODES_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_OUTPOST_ARN_FIELD, CACHE_CLUSTER_CREATE_TIME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, NOTIFICATION_CONFIGURATION_FIELD, CACHE_SECURITY_GROUPS_FIELD, CACHE_PARAMETER_GROUP_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_NODES_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SECURITY_GROUPS_FIELD, REPLICATION_GROUP_ID_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_ENABLED_FIELD, AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, ARN_FIELD, REPLICATION_GROUP_LOG_DELIVERY_ENABLED_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD, NETWORK_TYPE_FIELD, IP_DISCOVERY_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cacheClusterId;
    private final Endpoint configurationEndpoint;
    private final String clientDownloadLandingPage;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheClusterStatus;
    private final Integer numCacheNodes;
    private final String preferredAvailabilityZone;
    private final String preferredOutpostArn;
    private final Instant cacheClusterCreateTime;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final NotificationConfiguration notificationConfiguration;
    private final List<CacheSecurityGroupMembership> cacheSecurityGroups;
    private final CacheParameterGroupStatus cacheParameterGroup;
    private final String cacheSubnetGroupName;
    private final List<CacheNode> cacheNodes;
    private final Boolean autoMinorVersionUpgrade;
    private final List<SecurityGroupMembership> securityGroups;
    private final String replicationGroupId;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Boolean authTokenEnabled;
    private final Instant authTokenLastModifiedDate;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String arn;
    private final Boolean replicationGroupLogDeliveryEnabled;
    private final List<LogDeliveryConfiguration> logDeliveryConfigurations;
    private final String networkType;
    private final String ipDiscovery;
    private final String transitEncryptionMode;

    private CacheCluster(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.clientDownloadLandingPage = builder.clientDownloadLandingPage;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.numCacheNodes = builder.numCacheNodes;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredOutpostArn = builder.preferredOutpostArn;
        this.cacheClusterCreateTime = builder.cacheClusterCreateTime;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.cacheSecurityGroups = builder.cacheSecurityGroups;
        this.cacheParameterGroup = builder.cacheParameterGroup;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheNodes = builder.cacheNodes;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.securityGroups = builder.securityGroups;
        this.replicationGroupId = builder.replicationGroupId;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.authTokenLastModifiedDate = builder.authTokenLastModifiedDate;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.arn = builder.arn;
        this.replicationGroupLogDeliveryEnabled = builder.replicationGroupLogDeliveryEnabled;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
        this.transitEncryptionMode = builder.transitEncryptionMode;
    }

    public final String cacheClusterId() {
        return this.cacheClusterId;
    }

    public final Endpoint configurationEndpoint() {
        return this.configurationEndpoint;
    }

    public final String clientDownloadLandingPage() {
        return this.clientDownloadLandingPage;
    }

    public final String cacheNodeType() {
        return this.cacheNodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String cacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public final Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public final String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public final String preferredOutpostArn() {
        return this.preferredOutpostArn;
    }

    public final Instant cacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final boolean hasCacheSecurityGroups() {
        return this.cacheSecurityGroups != null && !(this.cacheSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<CacheSecurityGroupMembership> cacheSecurityGroups() {
        return this.cacheSecurityGroups;
    }

    public final CacheParameterGroupStatus cacheParameterGroup() {
        return this.cacheParameterGroup;
    }

    public final String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public final boolean hasCacheNodes() {
        return this.cacheNodes != null && !(this.cacheNodes instanceof SdkAutoConstructList);
    }

    public final List<CacheNode> cacheNodes() {
        return this.cacheNodes;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupMembership> securityGroups() {
        return this.securityGroups;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final Boolean authTokenEnabled() {
        return this.authTokenEnabled;
    }

    public final Instant authTokenLastModifiedDate() {
        return this.authTokenLastModifiedDate;
    }

    public final Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public final Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean replicationGroupLogDeliveryEnabled() {
        return this.replicationGroupLogDeliveryEnabled;
    }

    public final boolean hasLogDeliveryConfigurations() {
        return this.logDeliveryConfigurations != null && !(this.logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LogDeliveryConfiguration> logDeliveryConfigurations() {
        return this.logDeliveryConfigurations;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(this.ipDiscovery);
    }

    public final String ipDiscoveryAsString() {
        return this.ipDiscovery;
    }

    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(this.transitEncryptionMode);
    }

    public final String transitEncryptionModeAsString() {
        return this.transitEncryptionMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientDownloadLandingPage());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheSecurityGroups() ? this.cacheSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheNodes() ? this.cacheNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupLogDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheCluster)) {
            return false;
        }
        CacheCluster other = (CacheCluster)obj;
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.configurationEndpoint(), other.configurationEndpoint()) && Objects.equals(this.clientDownloadLandingPage(), other.clientDownloadLandingPage()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheClusterStatus(), other.cacheClusterStatus()) && Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && Objects.equals(this.preferredAvailabilityZone(), other.preferredAvailabilityZone()) && Objects.equals(this.preferredOutpostArn(), other.preferredOutpostArn()) && Objects.equals(this.cacheClusterCreateTime(), other.cacheClusterCreateTime()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && this.hasCacheSecurityGroups() == other.hasCacheSecurityGroups() && Objects.equals(this.cacheSecurityGroups(), other.cacheSecurityGroups()) && Objects.equals(this.cacheParameterGroup(), other.cacheParameterGroup()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && this.hasCacheNodes() == other.hasCacheNodes() && Objects.equals(this.cacheNodes(), other.cacheNodes()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.authTokenEnabled(), other.authTokenEnabled()) && Objects.equals(this.authTokenLastModifiedDate(), other.authTokenLastModifiedDate()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.replicationGroupLogDeliveryEnabled(), other.replicationGroupLogDeliveryEnabled()) && this.hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations() && Objects.equals(this.logDeliveryConfigurations(), other.logDeliveryConfigurations()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && Objects.equals(this.ipDiscoveryAsString(), other.ipDiscoveryAsString()) && Objects.equals(this.transitEncryptionModeAsString(), other.transitEncryptionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CacheCluster").add("CacheClusterId", (Object)this.cacheClusterId()).add("ConfigurationEndpoint", (Object)this.configurationEndpoint()).add("ClientDownloadLandingPage", (Object)this.clientDownloadLandingPage()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheClusterStatus", (Object)this.cacheClusterStatus()).add("NumCacheNodes", (Object)this.numCacheNodes()).add("PreferredAvailabilityZone", (Object)this.preferredAvailabilityZone()).add("PreferredOutpostArn", (Object)this.preferredOutpostArn()).add("CacheClusterCreateTime", (Object)this.cacheClusterCreateTime()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("CacheSecurityGroups", this.hasCacheSecurityGroups() ? this.cacheSecurityGroups() : null).add("CacheParameterGroup", (Object)this.cacheParameterGroup()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheNodes", this.hasCacheNodes() ? this.cacheNodes() : null).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("ReplicationGroupId", (Object)this.replicationGroupId()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("AuthTokenEnabled", (Object)this.authTokenEnabled()).add("AuthTokenLastModifiedDate", (Object)this.authTokenLastModifiedDate()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("ARN", (Object)this.arn()).add("ReplicationGroupLogDeliveryEnabled", (Object)this.replicationGroupLogDeliveryEnabled()).add("LogDeliveryConfigurations", this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null).add("NetworkType", (Object)this.networkTypeAsString()).add("IpDiscovery", (Object)this.ipDiscoveryAsString()).add("TransitEncryptionMode", (Object)this.transitEncryptionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "ConfigurationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.configurationEndpoint()));
            }
            case "ClientDownloadLandingPage": {
                return Optional.ofNullable(clazz.cast(this.clientDownloadLandingPage()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterStatus()));
            }
            case "NumCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.numCacheNodes()));
            }
            case "PreferredAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZone()));
            }
            case "PreferredOutpostArn": {
                return Optional.ofNullable(clazz.cast(this.preferredOutpostArn()));
            }
            case "CacheClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterCreateTime()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "CacheSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroups()));
            }
            case "CacheParameterGroup": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroup()));
            }
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheNodes": {
                return Optional.ofNullable(clazz.cast(this.cacheNodes()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "AuthTokenEnabled": {
                return Optional.ofNullable(clazz.cast(this.authTokenEnabled()));
            }
            case "AuthTokenLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.authTokenLastModifiedDate()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ReplicationGroupLogDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupLogDeliveryEnabled()));
            }
            case "LogDeliveryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfigurations()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "IpDiscovery": {
                return Optional.ofNullable(clazz.cast(this.ipDiscoveryAsString()));
            }
            case "TransitEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CacheClusterId", CACHE_CLUSTER_ID_FIELD);
        map.put("ConfigurationEndpoint", CONFIGURATION_ENDPOINT_FIELD);
        map.put("ClientDownloadLandingPage", CLIENT_DOWNLOAD_LANDING_PAGE_FIELD);
        map.put("CacheNodeType", CACHE_NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("CacheClusterStatus", CACHE_CLUSTER_STATUS_FIELD);
        map.put("NumCacheNodes", NUM_CACHE_NODES_FIELD);
        map.put("PreferredAvailabilityZone", PREFERRED_AVAILABILITY_ZONE_FIELD);
        map.put("PreferredOutpostArn", PREFERRED_OUTPOST_ARN_FIELD);
        map.put("CacheClusterCreateTime", CACHE_CLUSTER_CREATE_TIME_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("PendingModifiedValues", PENDING_MODIFIED_VALUES_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("CacheSecurityGroups", CACHE_SECURITY_GROUPS_FIELD);
        map.put("CacheParameterGroup", CACHE_PARAMETER_GROUP_FIELD);
        map.put("CacheSubnetGroupName", CACHE_SUBNET_GROUP_NAME_FIELD);
        map.put("CacheNodes", CACHE_NODES_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
        map.put("SnapshotWindow", SNAPSHOT_WINDOW_FIELD);
        map.put("AuthTokenEnabled", AUTH_TOKEN_ENABLED_FIELD);
        map.put("AuthTokenLastModifiedDate", AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD);
        map.put("TransitEncryptionEnabled", TRANSIT_ENCRYPTION_ENABLED_FIELD);
        map.put("AtRestEncryptionEnabled", AT_REST_ENCRYPTION_ENABLED_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("ReplicationGroupLogDeliveryEnabled", REPLICATION_GROUP_LOG_DELIVERY_ENABLED_FIELD);
        map.put("LogDeliveryConfigurations", LOG_DELIVERY_CONFIGURATIONS_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("IpDiscovery", IP_DISCOVERY_FIELD);
        map.put("TransitEncryptionMode", TRANSIT_ENCRYPTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheCluster, T> g) {
        return obj -> g.apply((CacheCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private Endpoint configurationEndpoint;
        private String clientDownloadLandingPage;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheClusterStatus;
        private Integer numCacheNodes;
        private String preferredAvailabilityZone;
        private String preferredOutpostArn;
        private Instant cacheClusterCreateTime;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private NotificationConfiguration notificationConfiguration;
        private List<CacheSecurityGroupMembership> cacheSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private CacheParameterGroupStatus cacheParameterGroup;
        private String cacheSubnetGroupName;
        private List<CacheNode> cacheNodes = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoMinorVersionUpgrade;
        private List<SecurityGroupMembership> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String replicationGroupId;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Boolean authTokenEnabled;
        private Instant authTokenLastModifiedDate;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String arn;
        private Boolean replicationGroupLogDeliveryEnabled;
        private List<LogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String networkType;
        private String ipDiscovery;
        private String transitEncryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheCluster model) {
            this.cacheClusterId(model.cacheClusterId);
            this.configurationEndpoint(model.configurationEndpoint);
            this.clientDownloadLandingPage(model.clientDownloadLandingPage);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheClusterStatus(model.cacheClusterStatus);
            this.numCacheNodes(model.numCacheNodes);
            this.preferredAvailabilityZone(model.preferredAvailabilityZone);
            this.preferredOutpostArn(model.preferredOutpostArn);
            this.cacheClusterCreateTime(model.cacheClusterCreateTime);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.notificationConfiguration(model.notificationConfiguration);
            this.cacheSecurityGroups(model.cacheSecurityGroups);
            this.cacheParameterGroup(model.cacheParameterGroup);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheNodes(model.cacheNodes);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.securityGroups(model.securityGroups);
            this.replicationGroupId(model.replicationGroupId);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.authTokenEnabled(model.authTokenEnabled);
            this.authTokenLastModifiedDate(model.authTokenLastModifiedDate);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.arn(model.arn);
            this.replicationGroupLogDeliveryEnabled(model.replicationGroupLogDeliveryEnabled);
            this.logDeliveryConfigurations(model.logDeliveryConfigurations);
            this.networkType(model.networkType);
            this.ipDiscovery(model.ipDiscovery);
            this.transitEncryptionMode(model.transitEncryptionMode);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final Endpoint.Builder getConfigurationEndpoint() {
            return this.configurationEndpoint != null ? this.configurationEndpoint.toBuilder() : null;
        }

        public final void setConfigurationEndpoint(Endpoint.BuilderImpl configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint != null ? configurationEndpoint.build() : null;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final String getClientDownloadLandingPage() {
            return this.clientDownloadLandingPage;
        }

        public final void setClientDownloadLandingPage(String clientDownloadLandingPage) {
            this.clientDownloadLandingPage = clientDownloadLandingPage;
        }

        @Override
        public final Builder clientDownloadLandingPage(String clientDownloadLandingPage) {
            this.clientDownloadLandingPage = clientDownloadLandingPage;
            return this;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheClusterStatus() {
            return this.cacheClusterStatus;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final String getPreferredOutpostArn() {
            return this.preferredOutpostArn;
        }

        public final void setPreferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
        }

        @Override
        public final Builder preferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        public final Instant getCacheClusterCreateTime() {
            return this.cacheClusterCreateTime;
        }

        public final void setCacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
        }

        @Override
        public final Builder cacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final List<CacheSecurityGroupMembership.Builder> getCacheSecurityGroups() {
            List<CacheSecurityGroupMembership.Builder> result = CacheSecurityGroupMembershipListCopier.copyToBuilder(this.cacheSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership.BuilderImpl> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupMembershipListCopier.copyFromBuilder(cacheSecurityGroups);
        }

        @Override
        public final Builder cacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupMembershipListCopier.copy(cacheSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Arrays.asList(cacheSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(Consumer<CacheSecurityGroupMembership.Builder> ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Stream.of(cacheSecurityGroups).map(c -> (CacheSecurityGroupMembership)((CacheSecurityGroupMembership.Builder)CacheSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CacheParameterGroupStatus.Builder getCacheParameterGroup() {
            return this.cacheParameterGroup != null ? this.cacheParameterGroup.toBuilder() : null;
        }

        public final void setCacheParameterGroup(CacheParameterGroupStatus.BuilderImpl cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup != null ? cacheParameterGroup.build() : null;
        }

        @Override
        public final Builder cacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
            return this;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final List<CacheNode.Builder> getCacheNodes() {
            List<CacheNode.Builder> result = CacheNodeListCopier.copyToBuilder(this.cacheNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheNodes(Collection<CacheNode.BuilderImpl> cacheNodes) {
            this.cacheNodes = CacheNodeListCopier.copyFromBuilder(cacheNodes);
        }

        @Override
        public final Builder cacheNodes(Collection<CacheNode> cacheNodes) {
            this.cacheNodes = CacheNodeListCopier.copy(cacheNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodes(CacheNode ... cacheNodes) {
            this.cacheNodes(Arrays.asList(cacheNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodes(Consumer<CacheNode.Builder> ... cacheNodes) {
            this.cacheNodes(Stream.of(cacheNodes).map(c -> (CacheNode)((CacheNode.Builder)CacheNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final List<SecurityGroupMembership.Builder> getSecurityGroups() {
            List<SecurityGroupMembership.Builder> result = SecurityGroupMembershipListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroupMembership)((SecurityGroupMembership.Builder)SecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Boolean getAuthTokenEnabled() {
            return this.authTokenEnabled;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final Instant getAuthTokenLastModifiedDate() {
            return this.authTokenLastModifiedDate;
        }

        public final void setAuthTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
        }

        @Override
        public final Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getReplicationGroupLogDeliveryEnabled() {
            return this.replicationGroupLogDeliveryEnabled;
        }

        public final void setReplicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled) {
            this.replicationGroupLogDeliveryEnabled = replicationGroupLogDeliveryEnabled;
        }

        @Override
        public final Builder replicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled) {
            this.replicationGroupLogDeliveryEnabled = replicationGroupLogDeliveryEnabled;
            return this;
        }

        public final List<LogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfiguration.Builder> result = LogDeliveryConfigurationListCopier.copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(Collection<LogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfiguration ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(Consumer<LogDeliveryConfiguration.Builder> ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Stream.of(logDeliveryConfigurations).map(c -> (LogDeliveryConfiguration)((LogDeliveryConfiguration.Builder)LogDeliveryConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return this.ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        public final String getTransitEncryptionMode() {
            return this.transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public CacheCluster build() {
            return new CacheCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheCluster> {
        public Builder cacheClusterId(String var1);

        public Builder configurationEndpoint(Endpoint var1);

        default public Builder configurationEndpoint(Consumer<Endpoint.Builder> configurationEndpoint) {
            return this.configurationEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(configurationEndpoint)).build());
        }

        public Builder clientDownloadLandingPage(String var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheClusterStatus(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder preferredOutpostArn(String var1);

        public Builder cacheClusterCreateTime(Instant var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((PendingModifiedValues)((PendingModifiedValues.Builder)PendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder cacheSecurityGroups(Collection<CacheSecurityGroupMembership> var1);

        public Builder cacheSecurityGroups(CacheSecurityGroupMembership ... var1);

        public Builder cacheSecurityGroups(Consumer<CacheSecurityGroupMembership.Builder> ... var1);

        public Builder cacheParameterGroup(CacheParameterGroupStatus var1);

        default public Builder cacheParameterGroup(Consumer<CacheParameterGroupStatus.Builder> cacheParameterGroup) {
            return this.cacheParameterGroup((CacheParameterGroupStatus)((CacheParameterGroupStatus.Builder)CacheParameterGroupStatus.builder().applyMutation(cacheParameterGroup)).build());
        }

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheNodes(Collection<CacheNode> var1);

        public Builder cacheNodes(CacheNode ... var1);

        public Builder cacheNodes(Consumer<CacheNode.Builder> ... var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder securityGroups(Collection<SecurityGroupMembership> var1);

        public Builder securityGroups(SecurityGroupMembership ... var1);

        public Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... var1);

        public Builder replicationGroupId(String var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder authTokenEnabled(Boolean var1);

        public Builder authTokenLastModifiedDate(Instant var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder arn(String var1);

        public Builder replicationGroupLogDeliveryEnabled(Boolean var1);

        public Builder logDeliveryConfigurations(Collection<LogDeliveryConfiguration> var1);

        public Builder logDeliveryConfigurations(LogDeliveryConfiguration ... var1);

        public Builder logDeliveryConfigurations(Consumer<LogDeliveryConfiguration.Builder> ... var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder ipDiscovery(String var1);

        public Builder ipDiscovery(IpDiscovery var1);

        public Builder transitEncryptionMode(String var1);

        public Builder transitEncryptionMode(TransitEncryptionMode var1);
    }
}

