/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.mysql.fluent.AdvisorsClient;
import com.azure.resourcemanager.mysql.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.mysql.fluent.ConfigurationsClient;
import com.azure.resourcemanager.mysql.fluent.DatabasesClient;
import com.azure.resourcemanager.mysql.fluent.FirewallRulesClient;
import com.azure.resourcemanager.mysql.fluent.LocationBasedPerformanceTiersClient;
import com.azure.resourcemanager.mysql.fluent.LocationBasedRecommendedActionSessionsOperationStatusClient;
import com.azure.resourcemanager.mysql.fluent.LocationBasedRecommendedActionSessionsResultsClient;
import com.azure.resourcemanager.mysql.fluent.LogFilesClient;
import com.azure.resourcemanager.mysql.fluent.MySqlManagementClient;
import com.azure.resourcemanager.mysql.fluent.OperationsClient;
import com.azure.resourcemanager.mysql.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.mysql.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.mysql.fluent.QueryTextsClient;
import com.azure.resourcemanager.mysql.fluent.RecommendedActionsClient;
import com.azure.resourcemanager.mysql.fluent.RecoverableServersClient;
import com.azure.resourcemanager.mysql.fluent.ReplicasClient;
import com.azure.resourcemanager.mysql.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.mysql.fluent.ServerAdministratorsClient;
import com.azure.resourcemanager.mysql.fluent.ServerBasedPerformanceTiersClient;
import com.azure.resourcemanager.mysql.fluent.ServerKeysClient;
import com.azure.resourcemanager.mysql.fluent.ServerParametersClient;
import com.azure.resourcemanager.mysql.fluent.ServerSecurityAlertPoliciesClient;
import com.azure.resourcemanager.mysql.fluent.ServersClient;
import com.azure.resourcemanager.mysql.fluent.TopQueryStatisticsClient;
import com.azure.resourcemanager.mysql.fluent.VirtualNetworkRulesClient;
import com.azure.resourcemanager.mysql.fluent.WaitStatisticsClient;
import com.azure.resourcemanager.mysql.implementation.AdvisorsClientImpl;
import com.azure.resourcemanager.mysql.implementation.CheckNameAvailabilitiesClientImpl;
import com.azure.resourcemanager.mysql.implementation.ConfigurationsClientImpl;
import com.azure.resourcemanager.mysql.implementation.DatabasesClientImpl;
import com.azure.resourcemanager.mysql.implementation.FirewallRulesClientImpl;
import com.azure.resourcemanager.mysql.implementation.LocationBasedPerformanceTiersClientImpl;
import com.azure.resourcemanager.mysql.implementation.LocationBasedRecommendedActionSessionsOperationStatusClientImpl;
import com.azure.resourcemanager.mysql.implementation.LocationBasedRecommendedActionSessionsResultsClientImpl;
import com.azure.resourcemanager.mysql.implementation.LogFilesClientImpl;
import com.azure.resourcemanager.mysql.implementation.MySqlManagementClientBuilder;
import com.azure.resourcemanager.mysql.implementation.OperationsClientImpl;
import com.azure.resourcemanager.mysql.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.mysql.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.mysql.implementation.QueryTextsClientImpl;
import com.azure.resourcemanager.mysql.implementation.RecommendedActionsClientImpl;
import com.azure.resourcemanager.mysql.implementation.RecoverableServersClientImpl;
import com.azure.resourcemanager.mysql.implementation.ReplicasClientImpl;
import com.azure.resourcemanager.mysql.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.mysql.implementation.ServerAdministratorsClientImpl;
import com.azure.resourcemanager.mysql.implementation.ServerBasedPerformanceTiersClientImpl;
import com.azure.resourcemanager.mysql.implementation.ServerKeysClientImpl;
import com.azure.resourcemanager.mysql.implementation.ServerParametersClientImpl;
import com.azure.resourcemanager.mysql.implementation.ServerSecurityAlertPoliciesClientImpl;
import com.azure.resourcemanager.mysql.implementation.ServersClientImpl;
import com.azure.resourcemanager.mysql.implementation.TopQueryStatisticsClientImpl;
import com.azure.resourcemanager.mysql.implementation.VirtualNetworkRulesClientImpl;
import com.azure.resourcemanager.mysql.implementation.WaitStatisticsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MySqlManagementClientBuilder.class)
public final class MySqlManagementClientImpl
implements MySqlManagementClient {
    private final ClientLogger logger = new ClientLogger(MySqlManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ServersClient servers;
    private final ReplicasClient replicas;
    private final FirewallRulesClient firewallRules;
    private final VirtualNetworkRulesClient virtualNetworkRules;
    private final DatabasesClient databases;
    private final ConfigurationsClient configurations;
    private final ServerParametersClient serverParameters;
    private final LogFilesClient logFiles;
    private final ServerAdministratorsClient serverAdministrators;
    private final RecoverableServersClient recoverableServers;
    private final ServerBasedPerformanceTiersClient serverBasedPerformanceTiers;
    private final LocationBasedPerformanceTiersClient locationBasedPerformanceTiers;
    private final CheckNameAvailabilitiesClient checkNameAvailabilities;
    private final OperationsClient operations;
    private final ServerSecurityAlertPoliciesClient serverSecurityAlertPolicies;
    private final QueryTextsClient queryTexts;
    private final TopQueryStatisticsClient topQueryStatistics;
    private final WaitStatisticsClient waitStatistics;
    private final ResourceProvidersClient resourceProviders;
    private final AdvisorsClient advisors;
    private final RecommendedActionsClient recommendedActions;
    private final LocationBasedRecommendedActionSessionsOperationStatusClient locationBasedRecommendedActionSessionsOperationStatus;
    private final LocationBasedRecommendedActionSessionsResultsClient locationBasedRecommendedActionSessionsResults;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final ServerKeysClient serverKeys;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ServersClient getServers() {
        return this.servers;
    }

    @Override
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    @Override
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    @Override
    public VirtualNetworkRulesClient getVirtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    @Override
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    @Override
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    @Override
    public ServerParametersClient getServerParameters() {
        return this.serverParameters;
    }

    @Override
    public LogFilesClient getLogFiles() {
        return this.logFiles;
    }

    @Override
    public ServerAdministratorsClient getServerAdministrators() {
        return this.serverAdministrators;
    }

    @Override
    public RecoverableServersClient getRecoverableServers() {
        return this.recoverableServers;
    }

    @Override
    public ServerBasedPerformanceTiersClient getServerBasedPerformanceTiers() {
        return this.serverBasedPerformanceTiers;
    }

    @Override
    public LocationBasedPerformanceTiersClient getLocationBasedPerformanceTiers() {
        return this.locationBasedPerformanceTiers;
    }

    @Override
    public CheckNameAvailabilitiesClient getCheckNameAvailabilities() {
        return this.checkNameAvailabilities;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ServerSecurityAlertPoliciesClient getServerSecurityAlertPolicies() {
        return this.serverSecurityAlertPolicies;
    }

    @Override
    public QueryTextsClient getQueryTexts() {
        return this.queryTexts;
    }

    @Override
    public TopQueryStatisticsClient getTopQueryStatistics() {
        return this.topQueryStatistics;
    }

    @Override
    public WaitStatisticsClient getWaitStatistics() {
        return this.waitStatistics;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public AdvisorsClient getAdvisors() {
        return this.advisors;
    }

    @Override
    public RecommendedActionsClient getRecommendedActions() {
        return this.recommendedActions;
    }

    @Override
    public LocationBasedRecommendedActionSessionsOperationStatusClient getLocationBasedRecommendedActionSessionsOperationStatus() {
        return this.locationBasedRecommendedActionSessionsOperationStatus;
    }

    @Override
    public LocationBasedRecommendedActionSessionsResultsClient getLocationBasedRecommendedActionSessionsResults() {
        return this.locationBasedRecommendedActionSessionsResults;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public ServerKeysClient getServerKeys() {
        return this.serverKeys;
    }

    MySqlManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.servers = new ServersClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.virtualNetworkRules = new VirtualNetworkRulesClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.serverParameters = new ServerParametersClientImpl(this);
        this.logFiles = new LogFilesClientImpl(this);
        this.serverAdministrators = new ServerAdministratorsClientImpl(this);
        this.recoverableServers = new RecoverableServersClientImpl(this);
        this.serverBasedPerformanceTiers = new ServerBasedPerformanceTiersClientImpl(this);
        this.locationBasedPerformanceTiers = new LocationBasedPerformanceTiersClientImpl(this);
        this.checkNameAvailabilities = new CheckNameAvailabilitiesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.serverSecurityAlertPolicies = new ServerSecurityAlertPoliciesClientImpl(this);
        this.queryTexts = new QueryTextsClientImpl(this);
        this.topQueryStatistics = new TopQueryStatisticsClientImpl(this);
        this.waitStatistics = new WaitStatisticsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.advisors = new AdvisorsClientImpl(this);
        this.recommendedActions = new RecommendedActionsClientImpl(this);
        this.locationBasedRecommendedActionSessionsOperationStatus = new LocationBasedRecommendedActionSessionsOperationStatusClientImpl(this);
        this.locationBasedRecommendedActionSessionsResults = new LocationBasedRecommendedActionSessionsResultsClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.serverKeys = new ServerKeysClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        for (Map.Entry entry : this.getContext().getValues().entrySet()) {
            context = context.addData(entry.getKey(), entry.getValue());
        }
        return context;
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        this.logger.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

