/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.TBVirtualConnectionDatabase;
import com.dbeaver.model.tableau.rest.api.VirtualConnectionSourceConnectionType;
import com.dbeaver.model.tableau.rest.api.VirtualConnectionType;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class TBVirtualConnection
implements TBObject {
    private static final Log log = Log.getLog(TBVirtualConnection.class);
    private final TBSite site;
    private final TBProject project;
    private final VirtualConnectionType virtualConnectionType;
    private List<TBVirtualConnectionDatabase> databases;

    public TBVirtualConnection(TBSite site, VirtualConnectionType virtualConnectionType, TBProject project) {
        this.site = site;
        this.virtualConnectionType = virtualConnectionType;
        this.project = project;
    }

    public TBSite getSite() {
        return this.site;
    }

    public TBSession getSession() {
        return this.site.getSession();
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.virtualConnectionType.getId();
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getName() {
        return this.virtualConnectionType.getName();
    }

    @Property(order=30)
    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(order=11, href=true)
    @Nullable
    public String getWebpageURL() {
        return this.virtualConnectionType.getWebpageUrl();
    }

    @Property(order=12, viewable=true)
    @Nullable
    public String getCreatedAt() {
        return String.valueOf(this.virtualConnectionType.getCreatedAt());
    }

    @Property(order=13, viewable=true)
    @Nullable
    public String getUpdatedAt() {
        return String.valueOf(this.virtualConnectionType.getUpdatedAt());
    }

    @Property(order=20)
    public TBProject getProject() {
        return this.project;
    }

    public List<TBVirtualConnectionDatabase> getDatabases(DBRProgressMonitor monitor) throws DBException {
        if (this.databases == null) {
            this.databases = this.site.getSession().executeRequest(monitor, this.site.makeSiteEndpoint("virtualConnections/" + this.virtualConnectionType.getId() + "/connections")).getVirtualConnectionConnections().getConnection().stream().map(p -> new TBVirtualConnectionDatabase(this, (VirtualConnectionSourceConnectionType)p)).collect(Collectors.toList());
        }
        return this.databases;
    }
}

