/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.files.ui.views;

import com.dbeaver.db.files.ui.views.FilePathInfoProvider;
import com.dbeaver.db.files.ui.views.FlatFilesConnectionPage;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class FilePathSelector
extends Composite {
    private final FilePathInfoProvider pathInfoProvider;
    private Menu contextMenu;
    private final Button browseButton;

    public FilePathSelector(Composite parent, FilePathInfoProvider pathInfoProvider) {
        this(parent, pathInfoProvider, "Edit", (DBPImage)UIIcon.OPEN);
    }

    public FilePathSelector(Composite parent, FilePathInfoProvider pathInfoProvider, String text, DBPImage icon) {
        super(parent, 0);
        this.pathInfoProvider = pathInfoProvider;
        this.setLayout((Layout)new FillLayout());
        this.browseButton = new Button((Composite)this, 1032);
        this.browseButton.setText(text);
        if (icon != null) {
            this.browseButton.setImage(DBeaverIcons.getImage((DBPImage)icon));
        }
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Point buttonSize = this.browseButton.getSize();
            Point location = this.browseButton.toDisplay(0, buttonSize.y - 1);
            Menu menu = this.createContextMenu(this.browseButton);
            menu.setLocation(location);
            menu.setVisible(true);
        }));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    private void chooseSourceFile(FlatFilesConnectionPage.FileSelectorType selectorType) {
        String result;
        if (selectorType == FlatFilesConnectionPage.FileSelectorType.REMOTE) {
            String[] extensions = this.pathInfoProvider.getFileExtensions(false);
            DBNPathBase selected = DBWorkbench.getPlatformUI().openFileSystemSelector("Input file", false, 4096, false, extensions, this.pathInfoProvider.getFilePath());
            if (selected != null) {
                this.pathInfoProvider.setFilePath(DBFUtils.convertPathToString((Path)selected.getPath()));
            }
        } else if (selectorType == FlatFilesConnectionPage.FileSelectorType.FILE) {
            String[] extensions = this.pathInfoProvider.getFileExtensions(true);
            File[] files = DialogUtils.openFileList((Shell)this.getShell(), (String)"Select input file", (String[])extensions);
            if (files != null && files.length > 0) {
                this.pathInfoProvider.setFilePath(Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.joining(";")));
            }
        } else if (selectorType == FlatFilesConnectionPage.FileSelectorType.FOLDER && (result = DialogUtils.openDirectoryDialog((Shell)this.getShell(), (String)"Select input folder", (String)this.pathInfoProvider.getFilePath())) != null) {
            this.pathInfoProvider.setFilePath(result);
        }
    }

    private Menu createContextMenu(Button browseButton) {
        if (this.contextMenu != null) {
            return this.contextMenu;
        }
        this.contextMenu = new Menu((Control)browseButton);
        this.createMenuItem(this.contextMenu, "File", UIMessages.text_with_open_dialog_browse, DBIcon.TREE_FILE, SelectionListener.widgetSelectedAdapter(e -> this.chooseSourceFile(FlatFilesConnectionPage.FileSelectorType.FILE)));
        this.createMenuItem(this.contextMenu, "Folder", UIMessages.text_with_open_dialog_browse, UIIcon.OPEN, SelectionListener.widgetSelectedAdapter(e -> this.chooseSourceFile(FlatFilesConnectionPage.FileSelectorType.FOLDER)));
        DBPProject project = this.pathInfoProvider.getProject();
        if (project != null && DBFUtils.supportsMultiFileSystems((DBPProject)project)) {
            this.createMenuItem(this.contextMenu, "Remote", UIMessages.text_with_open_dialog_browse_remote, UIIcon.OPEN_EXTERNAL, SelectionListener.widgetSelectedAdapter(e -> this.chooseSourceFile(FlatFilesConnectionPage.FileSelectorType.REMOTE)));
        }
        return this.contextMenu;
    }

    private void createMenuItem(@NotNull Menu menu, @NotNull String text, @Nullable String toolTip, @Nullable DBIcon icon, @NotNull SelectionListener listener) {
        MenuItem item = new MenuItem(menu, 0);
        item.setText(text);
        if (toolTip != null) {
            item.setToolTipText(toolTip);
        }
        if (icon != null) {
            item.setImage(DBeaverIcons.getImage((DBPImage)icon));
        }
        item.addSelectionListener(listener);
    }
}

