/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.EnableStatusEnum;
import java.io.IOException;

public final class Network
implements JsonSerializable<Network> {
    private EnableStatusEnum publicNetworkAccess;
    private String delegatedSubnetResourceId;
    private String privateDnsZoneResourceId;

    public EnableStatusEnum publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public String delegatedSubnetResourceId() {
        return this.delegatedSubnetResourceId;
    }

    public Network withDelegatedSubnetResourceId(String delegatedSubnetResourceId) {
        this.delegatedSubnetResourceId = delegatedSubnetResourceId;
        return this;
    }

    public String privateDnsZoneResourceId() {
        return this.privateDnsZoneResourceId;
    }

    public Network withPrivateDnsZoneResourceId(String privateDnsZoneResourceId) {
        this.privateDnsZoneResourceId = privateDnsZoneResourceId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("delegatedSubnetResourceId", this.delegatedSubnetResourceId);
        jsonWriter.writeStringField("privateDnsZoneResourceId", this.privateDnsZoneResourceId);
        return jsonWriter.writeEndObject();
    }

    public static Network fromJson(JsonReader jsonReader) throws IOException {
        return (Network)jsonReader.readObject(reader -> {
            Network deserializedNetwork = new Network();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNetwork.publicNetworkAccess = EnableStatusEnum.fromString(reader.getString());
                    continue;
                }
                if ("delegatedSubnetResourceId".equals(fieldName)) {
                    deserializedNetwork.delegatedSubnetResourceId = reader.getString();
                    continue;
                }
                if ("privateDnsZoneResourceId".equals(fieldName)) {
                    deserializedNetwork.privateDnsZoneResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetwork;
        });
    }
}

