/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.ReplicasClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ServerImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.Replicas;
import com.azure.resourcemanager.mysqlflexibleserver.models.Server;

public final class ReplicasImpl
implements Replicas {
    private static final ClientLogger LOGGER = new ClientLogger(ReplicasImpl.class);
    private final ReplicasClient innerClient;
    private final MySqlManager serviceManager;

    public ReplicasImpl(ReplicasClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Server> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerImpl((ServerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Server> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerImpl((ServerInner)((Object)inner1), this.manager()));
    }

    private ReplicasClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

