/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backup;
import com.azure.resourcemanager.mysqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.mysqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.mysqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.mysqlflexibleserver.models.Network;
import com.azure.resourcemanager.mysqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.mysqlflexibleserver.models.Storage;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ServerProperties
implements JsonSerializable<ServerProperties> {
    private String administratorLogin;
    private String administratorLoginPassword;
    private ServerVersion version;
    private String availabilityZone;
    private CreateMode createMode;
    private String sourceServerResourceId;
    private OffsetDateTime restorePointInTime;
    private ReplicationRole replicationRole;
    private Integer replicaCapacity;
    private DataEncryption dataEncryption;
    private ServerState state;
    private String fullyQualifiedDomainName;
    private Storage storage;
    private Backup backup;
    private HighAvailability highAvailability;
    private Network network;
    private MaintenanceWindow maintenanceWindow;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public ServerProperties withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public ServerProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String sourceServerResourceId() {
        return this.sourceServerResourceId;
    }

    public ServerProperties withSourceServerResourceId(String sourceServerResourceId) {
        this.sourceServerResourceId = sourceServerResourceId;
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ServerProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public ServerProperties withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public Integer replicaCapacity() {
        return this.replicaCapacity;
    }

    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    public ServerProperties withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    public ServerState state() {
        return this.state;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public Storage storage() {
        return this.storage;
    }

    public ServerProperties withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public Backup backup() {
        return this.backup;
    }

    public ServerProperties withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ServerProperties withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public Network network() {
        return this.network;
    }

    public ServerProperties withNetwork(Network network) {
        this.network = network;
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ServerProperties withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public void validate() {
        if (this.dataEncryption() != null) {
            this.dataEncryption().validate();
        }
        if (this.storage() != null) {
            this.storage().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.highAvailability() != null) {
            this.highAvailability().validate();
        }
        if (this.network() != null) {
            this.network().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("sourceServerResourceId", this.sourceServerResourceId);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("replicationRole", this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("dataEncryption", (JsonSerializable)this.dataEncryption);
        jsonWriter.writeJsonField("storage", (JsonSerializable)this.storage);
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("highAvailability", (JsonSerializable)this.highAvailability);
        jsonWriter.writeJsonField("network", (JsonSerializable)this.network);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        return jsonWriter.writeEndObject();
    }

    public static ServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerProperties)jsonReader.readObject(reader -> {
            ServerProperties deserializedServerProperties = new ServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerProperties.version = ServerVersion.fromString(reader.getString());
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedServerProperties.availabilityZone = reader.getString();
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("sourceServerResourceId".equals(fieldName)) {
                    deserializedServerProperties.sourceServerResourceId = reader.getString();
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedServerProperties.restorePointInTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerProperties.replicationRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replicaCapacity".equals(fieldName)) {
                    deserializedServerProperties.replicaCapacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dataEncryption".equals(fieldName)) {
                    deserializedServerProperties.dataEncryption = DataEncryption.fromJson(reader);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedServerProperties.state = ServerState.fromString(reader.getString());
                    continue;
                }
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedServerProperties.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    deserializedServerProperties.storage = Storage.fromJson(reader);
                    continue;
                }
                if ("backup".equals(fieldName)) {
                    deserializedServerProperties.backup = Backup.fromJson(reader);
                    continue;
                }
                if ("highAvailability".equals(fieldName)) {
                    deserializedServerProperties.highAvailability = HighAvailability.fromJson(reader);
                    continue;
                }
                if ("network".equals(fieldName)) {
                    deserializedServerProperties.network = Network.fromJson(reader);
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerProperties.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerProperties;
        });
    }
}

