/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class RepeatFunction
extends JdbcFunction {
    RepeatFunction() {
        super("REPEAT", "RPAD", JdbcFunction.FunctionCategory.STRING, 2, 2);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        List<Token> sizeArg = this.createSizeArg(args.get(1), args.get(0));
        List<Token> strArg = this.ensureHasWhitespacePrefix(args.get(0));
        return Arrays.asList(Collections.singletonList(Token.sql("''")), sizeArg, strArg);
    }

    private List<Token> createSizeArg(List<Token> rawSizeArg, List<Token> rawStrArg) {
        LinkedList<Token> size = new LinkedList<Token>(rawSizeArg);
        LinkedList<Token> str = new LinkedList<Token>(rawStrArg);
        this.trimWhitespace(str);
        List<Token> whitespaceSuffix = this.trimWhitespaceSuffix(size);
        LinkedList<Token> newArg = new LinkedList<Token>(size);
        newArg.add(Token.space());
        newArg.add(Token.sql("*"));
        newArg.add(Token.space());
        newArg.add(Token.sql("LENGTH("));
        newArg.addAll(str);
        newArg.add(Token.sql(")"));
        newArg.addAll(whitespaceSuffix);
        return newArg;
    }
}

