/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class LengthFunction
extends JdbcFunction {
    LengthFunction(String jdbcName) {
        super(jdbcName, "LENGTH", JdbcFunction.FunctionCategory.STRING, 1, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        ArrayList<List<Token>> processedArgs = new ArrayList<List<Token>>(2);
        List<Token> arg = args.get(0);
        if (this.jdbcName.equals("LENGTH")) {
            LinkedList<Token> newArg = new LinkedList<Token>();
            newArg.add(Token.sql("RTRIM("));
            newArg.addAll(arg);
            newArg.add(Token.sql(")"));
            arg = newArg;
        }
        if (args.size() != 2) {
            processedArgs.add(arg);
            return processedArgs;
        }
        String type = this.findFirstExpression(args.get(1)).map(Token::value).orElse("");
        if (type.equalsIgnoreCase("OCTETS")) {
            LinkedList<Token> newArg = new LinkedList<Token>();
            newArg.add(Token.sql("CAST("));
            newArg.addAll(arg);
            newArg.add(Token.space());
            newArg.add(Token.sql("AS"));
            newArg.add(Token.space());
            newArg.add(Token.sql("VARBINARY)"));
            processedArgs.add(newArg);
            return processedArgs;
        }
        if (type.equalsIgnoreCase("CHARACTERS")) {
            processedArgs.add(arg);
            return processedArgs;
        }
        String message = String.format("The second argument to the %s function must be \"CHARACTERS\" or \"OCTETS\", got \"%s\"", this.jdbcName, type);
        throw new FunctionExpressionException(message);
    }
}

