/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.configuration.ConnectionConfiguration;
import com.amazon.athena.jdbc.results.ExtendedColumnMetadata;
import com.amazon.athena.jdbc.results.ExtendedTableMetadata;
import com.amazon.athena.jdbc.results.IteratorResultSetBase;
import com.amazon.athena.jdbc.results.ListTableMetadataResultSet;
import com.amazon.athena.jdbc.support.LikePatternHelper;
import com.amazon.athena.jdbc.support.PaginatingIteratorBase;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import software.amazon.awssdk.services.athena.model.Column;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.utils.Pair;

public class TableColumnsResultSet
extends IteratorResultSetBase<ExtendedColumnMetadata> {
    private static final String COLUMNS_TABLE_NAME = "COLUMNS";
    private static final String CATALOG_COLUMN_NAME = "TABLE_CAT";
    private static final String SCHEMA_COLUMN_NAME = "TABLE_SCHEM";
    private static final String TABLE_NAME_COLUMN_NAME = "TABLE_NAME";
    private static final String COLUMN_NAME_COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE_COLUMN_NAME = "DATA_TYPE";
    private static final String TYPE_NAME_COLUMN_NAME = "TYPE_NAME";
    private static final String COLUMN_SIZE_COLUMN_NAME = "COLUMN_SIZE";
    private static final String BUFFER_LENGTH_COLUMN_NAME = "BUFFER_LENGTH";
    private static final String DECIMAL_DIGITS_COLUMN_NAME = "DECIMAL_DIGITS";
    private static final String RADIX_COLUMN_NAME = "NUM_PREC_RADIX";
    private static final String NULLABLE_COLUMN_NAME = "NULLABLE";
    private static final String REMARKS_COLUMN_NAME = "REMARKS";
    private static final String DEFAULT_VALUE_COLUMN_NAME = "COLUMN_DEF";
    private static final String SQL_DATA_TYPE_COLUMN_NAME = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB_COLUMN_NAME = "SQL_DATETIME_SUB";
    private static final String MAX_CHAR_OCTET_LENGTH_COLUMN_NAME = "CHAR_OCTET_LENGTH";
    private static final String ORDINAL_POSITION_COLUMN_NAME = "ORDINAL_POSITION";
    private static final String IS_NULLABLE_COLUMN_NAME = "IS_NULLABLE";
    private static final String SCOPE_CATALOG_COLUMN_NAME = "SCOPE_CATALOG";
    private static final String SCOPE_SCHEMA_COLUMN_NAME = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE_COLUMN_NAME = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE_COLUMN_NAME = "SOURCE_DATA_TYPE";
    private static final String IS_AUTO_INCREMENT_COLUMN_NAME = "IS_AUTOINCREMENT";
    private static final String IS_GENERATED_COLUMN_COLUMN_NAME = "IS_GENERATEDCOLUMN";
    private static final ResultSetMetadata META_DATA = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo(new ColumnInfo[]{(ColumnInfo)ColumnInfo.builder().label("TABLE_CAT").name("TABLE_CAT").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(256)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("TABLE_SCHEM").name("TABLE_SCHEM").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(128)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("TABLE_NAME").name("TABLE_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(128)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("COLUMN_NAME").name("COLUMN_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(128)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("DATA_TYPE").name("DATA_TYPE").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("TYPE_NAME").name("TYPE_NAME").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(4096)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("COLUMN_SIZE").name("COLUMN_SIZE").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("BUFFER_LENGTH").name("BUFFER_LENGTH").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("DECIMAL_DIGITS").name("DECIMAL_DIGITS").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("NUM_PREC_RADIX").name("NUM_PREC_RADIX").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("NULLABLE").name("NULLABLE").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("REMARKS").name("REMARKS").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(255)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("COLUMN_DEF").name("COLUMN_DEF").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("SQL_DATA_TYPE").name("SQL_DATA_TYPE").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("SQL_DATETIME_SUB").name("SQL_DATETIME_SUB").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("CHAR_OCTET_LENGTH").name("CHAR_OCTET_LENGTH").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("ORDINAL_POSITION").name("ORDINAL_POSITION").type(AthenaDataType.INTEGER.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("IS_NULLABLE").name("IS_NULLABLE").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(3)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("SCOPE_CATALOG").name("SCOPE_CATALOG").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("SCOPE_SCHEMA").name("SCOPE_SCHEMA").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("SCOPE_TABLE").name("SCOPE_TABLE").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("SOURCE_DATA_TYPE").name("SOURCE_DATA_TYPE").type(AthenaDataType.SMALLINT.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(0)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("IS_AUTOINCREMENT").name("IS_AUTOINCREMENT").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(3)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build(), (ColumnInfo)ColumnInfo.builder().label("IS_GENERATEDCOLUMN").name("IS_GENERATEDCOLUMN").type(AthenaDataType.VARCHAR.athenaName()).tableName("COLUMNS").schemaName("INFORMATION_SCHEMA").catalogName("AwsDataCatalog").precision(Integer.valueOf(3)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NOT_NULL).caseSensitive(Boolean.valueOf(false)).build()}).build();
    private static final int CATALOG_COLUMN_INDEX = 1;
    private static final int COLUMN_INDEX_TABLE_SCHEM = 2;
    private static final int TABLE_NAME_COLUMN_INDEX = 3;
    private static final int COLUMN_NAME_COLUMN_INDEX = 4;
    private static final int DATA_TYPE_COLUMN_INDEX = 5;
    private static final int TYPE_NAME_COLUMN_INDEX = 6;
    private static final int COLUMN_SIZE_COLUMN_INDEX = 7;
    private static final int DECIMAL_DIGITS_COLUMN_INDEX = 9;
    private static final int NULLABLE_COLUMN_INDEX = 11;
    private static final int REMARKS_COLUMN_INDEX = 12;
    private static final int ORDINAL_POSITION_COLUMN_INDEX = 17;
    private static final int IS_NULLABLE_COLUMN_INDEX = 18;
    private static final int IS_AUTOINCREMENT_COLUMN_INDEX = 23;
    private static final int IS_GENERATEDCOLUMN_COLUMN_INDEX = 24;
    private final ConnectionConfiguration configuration;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnNamePattern;
    private final Iterator<ExtendedTableMetadata> tableIterator;

    public TableColumnsResultSet(ConnectionConfiguration configuration, String catalogName, String schemaNamePattern, String tableNamePattern, String columnNamePattern) {
        super(META_DATA);
        this.configuration = configuration;
        this.catalogName = LikePatternHelper.unescapeWildcards(catalogName);
        this.schemaName = schemaNamePattern;
        this.tableName = tableNamePattern;
        this.columnNamePattern = columnNamePattern;
        this.tableIterator = new ListTableMetadataResultSet(configuration, catalogName, schemaNamePattern, tableNamePattern, null).iterator();
    }

    @Override
    protected Iterator<ExtendedColumnMetadata> iterator() {
        if (!(this.schemaName != null && this.schemaName.length() <= 0 || this.tableName != null && this.tableName.length() <= 0 || this.columnNamePattern != null && this.columnNamePattern.length() <= 0)) {
            return new ColumnMetadataIterator(this.tableIterator, this.configuration.getApiRequestTimeout(), this.columnNamePattern);
        }
        return Collections.emptyIterator();
    }

    @Override
    protected String stringValue(ExtendedColumnMetadata currentRow, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return currentRow.getCatalogName();
            }
            case 2: {
                return currentRow.getSchemaName();
            }
            case 3: {
                return currentRow.getTableName();
            }
            case 4: {
                return currentRow.getName();
            }
            case 5: {
                return String.valueOf(AthenaDataType.of(currentRow.getType()).jdbcType());
            }
            case 6: {
                return currentRow.getType();
            }
            case 7: {
                int size = currentRow.getColumnSize();
                if (size == -1) {
                    return null;
                }
                return String.valueOf(size);
            }
            case 9: {
                int size = currentRow.getDecimalDigits();
                if (size == -1) {
                    return null;
                }
                return String.valueOf(size);
            }
            case 11: {
                return String.valueOf(2);
            }
            case 12: {
                return currentRow.getComment();
            }
            case 17: {
                return String.valueOf(currentRow.getColumnIndex());
            }
            case 18: {
                return "";
            }
            case 23: 
            case 24: {
                return "";
            }
        }
        return null;
    }

    private static class ColumnMetadataIterator
    extends PaginatingIteratorBase<ExtendedColumnMetadata> {
        private final String columnNamePattern;
        private final Iterator<ExtendedTableMetadata> tableMetadataIterator;
        private ExtendedTableMetadata currentTable;

        ColumnMetadataIterator(Iterator<ExtendedTableMetadata> tableMetadataIterator, Duration requestTimeout, String columnNamePattern) {
            super(requestTimeout);
            this.columnNamePattern = columnNamePattern;
            this.tableMetadataIterator = tableMetadataIterator;
        }

        @Override
        public boolean hasNext() {
            while ((this.currentPage == null || this.currentPage.isEmpty()) && this.tableMetadataIterator.hasNext()) {
                this.currentTable = this.tableMetadataIterator.next();
                this.loadNextPage();
            }
            while (this.pageIsExhausted() && this.tableMetadataIterator.hasNext()) {
                this.currentTable = this.tableMetadataIterator.next();
                this.loadNextPage();
            }
            return !this.pageIsExhausted();
        }

        private boolean pageIsExhausted() {
            return this.currentPage == null || this.exhausted && this.currentIndex + 1 >= this.currentPage.size();
        }

        @Override
        protected CompletableFuture<Pair<List<ExtendedColumnMetadata>, Optional<String>>> loadNextPage(Optional<String> ignored) {
            List columns = this.currentTable.getTableMetadata().map(metadata -> Stream.concat(metadata.columns().stream(), metadata.partitionKeys().stream()).filter(column -> LikePatternHelper.matches(this.columnNamePattern, column.name())).collect(Collectors.toList())).orElse(Collections.emptyList());
            List extendedColumnMetadataList = IntStream.range(0, columns.size()).mapToObj(i -> new ExtendedColumnMetadata(this.currentTable.getTableMetadata().get(), this.currentTable.getCatalogName(), this.currentTable.getSchemaName(), (Column)columns.get(i), i + 1)).collect(Collectors.toList());
            return CompletableFuture.supplyAsync(() -> Pair.of((Object)extendedColumnMetadataList, Optional.empty()));
        }
    }
}

