/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.AthenaResultSetMetaData;
import com.amazon.athena.jdbc.support.AutoUnwrap;
import com.amazon.athena.jdbc.support.UncheckedSQLException;
import com.amazon.athena.logging.AthenaLogger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.stream.IntStream;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Pair;

public abstract class IteratorResultSetBase<RowType>
implements ResultSet,
AutoUnwrap {
    private static final String ATHENA_POSITIVE_INFINITY = "Infinity";
    private static final String ATHENA_NEGATIVE_INFINITY = "-Infinity";
    private static final String ATHENA_NOT_A_NUMBER = "NaN";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]";
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd[ HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]]");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("[yyyy-MM-dd ]HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]");
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("[yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]][yyyy-MM-dd][HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]]");
    private static final int DEFAULT_FETCH_SIZE = 10000;
    private static final AthenaLogger logger = AthenaLogger.of(IteratorResultSetBase.class);
    private final AthenaResultSetMetaData metaData;
    private final ZoneId localTimeZoneId;
    private Closeable openStream;
    private Iterator<RowType> rows;
    private boolean open;
    private boolean iteratorExhausted;
    private RowType currentRow;
    private RowType nextRow;
    private int rowNumber;
    private boolean lastValueWasNull;
    private int fetchSize;
    private int maxFieldSize;
    private int maxRows;

    public IteratorResultSetBase(ResultSetMetadata athenaResultSetMetadata) {
        this(athenaResultSetMetadata, ZoneId.systemDefault(), 0, 0, 0);
    }

    public IteratorResultSetBase(ResultSetMetadata athenaResultSetMetadata, int maxRows, int maxFieldSize, int fetchSize) {
        this(athenaResultSetMetadata, ZoneId.systemDefault(), maxRows, maxFieldSize, fetchSize);
    }

    IteratorResultSetBase(ResultSetMetadata athenaResultSetMetadata, ZoneId localTimeZoneId, int maxRows, int maxFieldSize, int fetchSize) {
        this.metaData = new AthenaResultSetMetaData(athenaResultSetMetadata);
        this.localTimeZoneId = localTimeZoneId;
        this.openStream = null;
        this.open = true;
        this.rows = null;
        this.currentRow = null;
        this.nextRow = null;
        this.rowNumber = 0;
        this.lastValueWasNull = false;
        this.iteratorExhausted = false;
        this.fetchSize = fetchSize;
        this.maxFieldSize = maxFieldSize;
        this.maxRows = maxRows;
    }

    @Override
    public void close() throws SQLException {
        this.open = false;
        this.closeOpenStream();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    private void ensureOpen() throws SQLException {
        if (!this.open) {
            throw new SQLException("Result set is closed");
        }
    }

    private void ensureValidColumn(int columnIndex) throws SQLException {
        this.getMetaData().isSearchable(columnIndex);
    }

    private void ensureValidRow() throws SQLException {
        if (this.isBeforeFirst()) {
            throw new SQLException("Cannot read from a result set positioned before the first row");
        }
        if (this.isAfterLast()) {
            throw new SQLException("Cannot read from a result set positioned after the last row");
        }
    }

    private <T extends Closeable> T swapOpenStream(T stream) {
        IoUtils.closeQuietly((AutoCloseable)this.openStream, null);
        this.openStream = stream;
        return stream;
    }

    private void closeOpenStream() {
        this.swapOpenStream(null);
    }

    protected abstract Iterator<RowType> iterator();

    protected int fetchSize() {
        return this.fetchSize == 0 ? 10000 : this.fetchSize;
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen();
        this.closeOpenStream();
        try {
            if (this.rows == null) {
                this.rows = this.iterator();
            }
            if (this.maxRows != 0 && this.rowNumber == this.maxRows) {
                this.currentRow = null;
                this.iteratorExhausted = true;
                return false;
            }
            if (this.nextRow != null) {
                ++this.rowNumber;
                this.currentRow = this.nextRow;
                this.nextRow = this.rows.hasNext() ? this.rows.next() : null;
                return true;
            }
            if (this.rows.hasNext()) {
                ++this.rowNumber;
                this.currentRow = this.rows.next();
                this.nextRow = this.rows.hasNext() ? this.rows.next() : null;
                return true;
            }
            this.currentRow = null;
            this.iteratorExhausted = true;
            return false;
        }
        catch (UncheckedSQLException e) {
            throw (SQLException)e.getCause();
        }
        catch (CompletionException e) {
            throw new SQLException(e.getCause().getMessage(), e.getCause());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.metaData;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.ensureOpen();
        return this.lastValueWasNull;
    }

    protected abstract String stringValue(RowType var1, int var2);

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.ensureOpen();
        this.ensureValidRow();
        this.ensureValidColumn(columnIndex);
        this.closeOpenStream();
        String value = this.stringValue(this.currentRow, columnIndex);
        this.lastValueWasNull = value == null;
        return this.applyMaxFieldSize(columnIndex, value);
    }

    private String getFullString(int columnIndex) throws SQLException {
        String value = this.stringValue(this.currentRow, columnIndex);
        this.lastValueWasNull = value == null;
        return value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String str = this.getFullString(columnIndex);
        if (str == null) {
            return null;
        }
        if (this.getMetaData().getColumnType(columnIndex) == -3) {
            char[] chars = str.toCharArray();
            int length = (chars.length + 1) / 3;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                char highNibble = chars[i * 3];
                char lowNibble = chars[i * 3 + 1];
                int highValue = Character.digit(highNibble, 16) << 4;
                int lowValue = Character.digit(lowNibble, 16);
                bytes[i] = (byte)((highValue | lowValue) & 0xFF);
            }
            return this.applyMaxFieldSize(columnIndex, bytes);
        }
        return this.applyMaxFieldSize(columnIndex, str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return false;
        }
        str = str.trim();
        switch (this.getMetaData().getColumnType(columnIndex)) {
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return Double.parseDouble(str) != 0.0;
            }
        }
        return str.length() != 0 && !str.equals("0") && !str.equalsIgnoreCase("false");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        str = this.convertNullOrBooleanValue(str);
        str = this.cutAwayTheFractionPart(str.trim());
        switch (str = str.trim()) {
            case "Infinity": {
                return 127;
            }
            case "-Infinity": {
                return -128;
            }
            case "NaN": {
                return 0;
            }
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to byte", str), e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        str = this.convertNullOrBooleanValue(str);
        str = this.cutAwayTheFractionPart(str.trim());
        switch (str = str.trim()) {
            case "Infinity": {
                return Short.MAX_VALUE;
            }
            case "-Infinity": {
                return Short.MIN_VALUE;
            }
            case "NaN": {
                return 0;
            }
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to short", str), e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        str = this.convertNullOrBooleanValue(str);
        str = this.cutAwayTheFractionPart(str.trim());
        switch (str = str.trim()) {
            case "Infinity": {
                return Integer.MAX_VALUE;
            }
            case "-Infinity": {
                return Integer.MIN_VALUE;
            }
            case "NaN": {
                return 0;
            }
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to int", str), e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        str = this.convertNullOrBooleanValue(str);
        str = this.cutAwayTheFractionPart(str.trim());
        switch (str = str.trim()) {
            case "Infinity": {
                return Long.MAX_VALUE;
            }
            case "-Infinity": {
                return Long.MIN_VALUE;
            }
            case "NaN": {
                return 0L;
            }
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to long", str), e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        str = this.convertNullOrBooleanValue(str);
        try {
            String s = str.trim();
            float f = Float.parseFloat(s);
            if (Float.isFinite(f)) {
                return f;
            }
            if (s.equals(ATHENA_POSITIVE_INFINITY)) {
                return Float.POSITIVE_INFINITY;
            }
            if (s.equals(ATHENA_NEGATIVE_INFINITY)) {
                return Float.NEGATIVE_INFINITY;
            }
            if (s.equals(ATHENA_NOT_A_NUMBER)) {
                return Float.NaN;
            }
            throw new SQLDataException(String.format("Cannot convert \"%s\" to float", str));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to float", str), e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        str = this.convertNullOrBooleanValue(str);
        try {
            String s = str.trim();
            double d = Double.parseDouble(s);
            if (Double.isFinite(d)) {
                return d;
            }
            if (s.equals(ATHENA_POSITIVE_INFINITY)) {
                return Double.POSITIVE_INFINITY;
            }
            if (s.equals(ATHENA_NEGATIVE_INFINITY)) {
                return Double.NEGATIVE_INFINITY;
            }
            if (s.equals(ATHENA_NOT_A_NUMBER)) {
                return Double.NaN;
            }
            throw new SQLDataException(String.format("Cannot convert \"%s\" to double", str));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to double", str), e);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        return this.swapOpenStream(new ByteArrayInputStream(str.getBytes(StandardCharsets.US_ASCII)));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        return this.swapOpenStream(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        return this.swapOpenStream(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Named cursors are not supported");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        switch (this.getMetaData().getColumnType(columnIndex)) {
            case -6: {
                byte b = this.getByte(columnIndex);
                return this.wasNull() ? null : Byte.valueOf(b);
            }
            case 5: {
                short s = this.getShort(columnIndex);
                return this.wasNull() ? null : Short.valueOf(s);
            }
            case 4: {
                int i = this.getInt(columnIndex);
                return this.wasNull() ? null : Integer.valueOf(i);
            }
            case -5: {
                long l = this.getLong(columnIndex);
                return this.wasNull() ? null : Long.valueOf(l);
            }
            case 6: 
            case 7: {
                float f = this.getFloat(columnIndex);
                return this.wasNull() ? null : Float.valueOf(f);
            }
            case 8: {
                double d = this.getDouble(columnIndex);
                return this.wasNull() ? null : Double.valueOf(d);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -7: 
            case 16: {
                boolean t = this.getBoolean(columnIndex);
                return this.wasNull() ? null : Boolean.valueOf(t);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: 
            case 2013: {
                return this.getTime(columnIndex);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.ensureOpen();
        int columnIndex = this.metaData.findColumnIndex(columnLabel);
        if (columnIndex == 0) {
            throw new SQLException(String.format("Column \"%s\" does not exist in this result set", columnLabel));
        }
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        return this.swapOpenStream(new StringReader(str));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        str = this.convertNullOrBooleanValue(str);
        try {
            return new BigDecimal(str.trim());
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to BigDecimal", str), e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureOpen();
        return this.rowNumber == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureOpen();
        return this.iteratorExhausted;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureOpen();
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureOpen();
        return this.currentRow != null && this.nextRow == null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ensureOpen();
        if (!this.isBeforeFirst()) {
            throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.ensureOpen();
        while (this.next()) {
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.ensureOpen();
        if (this.isBeforeFirst()) {
            return this.next();
        }
        if (this.isFirst()) {
            return true;
        }
        throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
    }

    @Override
    public boolean last() throws SQLException {
        this.ensureOpen();
        if (this.isAfterLast()) {
            throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
        }
        if (this.isLast()) {
            return true;
        }
        if (!this.next()) {
            return false;
        }
        while (!this.isLast()) {
            this.next();
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureOpen();
        return this.isAfterLast() ? 0 : this.rowNumber;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.ensureOpen();
        if (row < 0 || row < this.rowNumber) {
            throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
        }
        while (this.rowNumber < row && this.next()) {
        }
        return !this.isAfterLast();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.ensureOpen();
        if (rows < 0) {
            throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
        }
        for (int i = 0; i < rows && this.next(); ++i) {
        }
        return !this.isAfterLast();
    }

    @Override
    public boolean previous() throws SQLException {
        this.ensureOpen();
        throw new SQLFeatureNotSupportedException("Result set movements other than forward are not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Fetch is only supported in the forward direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (!this.isIterating()) {
            this.ensureOpen();
            if (rows < 0) throw new SQLException(String.format("Invalid fetch size: %d (expected a positive integer)", rows));
            this.fetchSize = rows;
            return;
        } else {
            logger.warn("Changing the fetch size while the result set is iterated is not possible and will be ignored.", new Object[0]);
        }
    }

    private boolean isIterating() {
        return this.rows != null;
    }

    private boolean isColumnTrimmable(int columnIndex) throws SQLException {
        switch (this.getMetaData().getColumnType(columnIndex)) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] applyMaxFieldSize(int columnIndex, byte[] bytes) throws SQLException {
        if (this.maxFieldSize > 0 && bytes.length > this.maxFieldSize && this.isColumnTrimmable(columnIndex)) {
            return Arrays.copyOfRange(bytes, 0, this.maxFieldSize);
        }
        return bytes;
    }

    private String applyMaxFieldSize(int columnIndex, String string) throws SQLException {
        if (this.maxFieldSize > 0 && string.length() > this.maxFieldSize && this.isColumnTrimmable(columnIndex)) {
            return string.substring(0, this.maxFieldSize);
        }
        return string;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.fetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void insertRow() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateRow() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        String columnName = this.getMetaData().getColumnName(columnIndex);
        String columnTypeName = this.getMetaData().getColumnTypeName(columnIndex);
        if (this.getObject(columnIndex) == null) {
            return null;
        }
        if (map == null) {
            throw new NullPointerException("SQL mappings can be null only when the value at the given column index is null");
        }
        if (map.containsKey(columnTypeName)) {
            Class<?> targetClass = map.get(columnTypeName);
            return targetClass.cast(this.getObject(columnIndex));
        }
        throw new SQLException(String.format("Could not convert column \"%s\" to a Java type because no mapping was provided for columns of type \"%s\"", columnName, columnTypeName));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Ref type is not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes == null) {
            return null;
        }
        return this.swapOpenStream(new AthenaBlob(this.getBytes(columnIndex)));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.getNClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            String[] elements = str.substring(1, str.length() - 1).split(", ");
            return this.swapOpenStream(new AthenaArray(elements));
        }
        throw new SQLDataException(String.format("Cannot convert \"%s\" to an array", str));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            ZoneId targetZone = calendar == null ? this.localTimeZoneId : calendar.getTimeZone().toZoneId();
            LocalDate date = DATE_FORMAT.parse((CharSequence)str.trim(), TemporalQueries.localDate());
            ZonedDateTime zonedTimestamp = ZonedDateTime.of(date, LocalTime.of(0, 0), targetZone);
            zonedTimestamp = zonedTimestamp.withZoneSameInstant(this.localTimeZoneId);
            return Date.valueOf(zonedTimestamp.toLocalDate());
        }
        catch (DateTimeParseException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to Date", str), e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), calendar);
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        String trimmedStr = str.trim();
        try {
            ZoneId targetZone = calendar == null ? this.localTimeZoneId : calendar.getTimeZone().toZoneId();
            LocalTime time = TIME_FORMAT.parse((CharSequence)trimmedStr, TemporalQueries.localTime());
            ZoneId zone = TIME_FORMAT.parse((CharSequence)trimmedStr, TemporalQueries.zone());
            ZonedDateTime zonedTimestamp = zone != null ? ZonedDateTime.of(LocalDate.now(zone), time, zone) : ZonedDateTime.of(LocalDate.now(targetZone), time, targetZone);
            zonedTimestamp = zonedTimestamp.withZoneSameInstant(this.localTimeZoneId);
            return Time.valueOf(zonedTimestamp.toLocalTime());
        }
        catch (DateTimeParseException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to Time", str), e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), calendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            ZoneId targetZone = calendar == null ? this.localTimeZoneId : calendar.getTimeZone().toZoneId();
            TemporalAccessor parsedTimestamp = TIMESTAMP_FORMAT.parseBest(str.trim(), ZonedDateTime::from, LocalDateTime::from, LocalTime::from, LocalDate::from);
            ZonedDateTime zonedTimestamp = parsedTimestamp instanceof ZonedDateTime ? (ZonedDateTime)parsedTimestamp : (parsedTimestamp instanceof LocalDateTime ? ((LocalDateTime)parsedTimestamp).atZone(targetZone) : (parsedTimestamp instanceof LocalTime ? LocalDateTime.of(LocalDate.ofEpochDay(0L), (LocalTime)parsedTimestamp).atZone(targetZone) : LocalDateTime.of((LocalDate)parsedTimestamp, LocalTime.of(0, 0)).atZone(targetZone)));
            return new Timestamp(zonedTimestamp.toInstant().toEpochMilli());
        }
        catch (DateTimeParseException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to Timestamp", str), e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), calendar);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            throw new SQLDataException(String.format("Cannot convert \"%s\" to URL", str), e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("The RowId type is not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        return this.swapOpenStream(new AthenaNClob(str));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("The SQLXML type is not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.resultSetMutationNotSupportedByAthena();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return type.cast(this.getObject(columnIndex));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    private String cutAwayTheFractionPart(String str) {
        if (str != null && str.contains(".")) {
            str = str.split("\\.")[0];
        }
        return str;
    }

    private String convertNullOrBooleanValue(String str) {
        if (str == null || str.equalsIgnoreCase("false")) {
            return "0";
        }
        if (str.equalsIgnoreCase("true")) {
            return "1";
        }
        return str;
    }

    private SQLException resultSetMutationNotSupportedByAthena() {
        return new SQLFeatureNotSupportedException("Result set mutation is not supported");
    }

    private static class AthenaNClob
    implements NClob,
    Closeable {
        private final String str;
        private Closeable openStream;

        AthenaNClob(String str) {
            this.str = str;
            this.openStream = null;
        }

        private <T extends Closeable> T swapOpenStream(T stream) {
            IoUtils.closeQuietly((AutoCloseable)this.openStream, null);
            this.openStream = stream;
            return stream;
        }

        @Override
        public long length() throws SQLException {
            return this.str.length();
        }

        private void checkPosition(long position, long length) throws SQLException {
            if (position > Integer.MAX_VALUE) {
                throw new SQLFeatureNotSupportedException(String.format("Clob positions larger than %d are not supported", Integer.MAX_VALUE));
            }
            if (length > Integer.MAX_VALUE) {
                throw new SQLFeatureNotSupportedException(String.format("Clob lengths larger than %d are not supported", Integer.MAX_VALUE));
            }
            if (position < 1L || position > this.length()) {
                throw new IllegalArgumentException(String.format("Invalid clob position: %d", position));
            }
            if (position + length - 1L > this.length()) {
                throw new IllegalArgumentException(String.format("Invalid clob position: %d", position - 1L + length));
            }
            if (length < 0L) {
                throw new IllegalArgumentException(String.format("Invalid clob length: %d", length));
            }
        }

        @Override
        public String getSubString(long position, int length) throws SQLException {
            this.checkPosition(position, length);
            int from = (int)position - 1;
            int to = (int)position - 1 + length;
            return this.str.substring(from, to);
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return this.swapOpenStream(new StringReader(this.str));
        }

        @Override
        public InputStream getAsciiStream() throws SQLException {
            return this.swapOpenStream(new ByteArrayInputStream(this.str.getBytes(StandardCharsets.US_ASCII)));
        }

        @Override
        public long position(String needle, long start) throws SQLException {
            this.checkPosition(start, 0L);
            int index = this.str.indexOf(needle, (int)(start - 1L));
            if (index == -1) {
                return -1L;
            }
            return index + 1;
        }

        @Override
        public long position(Clob needle, long start) throws SQLException {
            this.checkPosition(start, 0L);
            return this.position(needle.getSubString(1L, (int)needle.length()), start);
        }

        @Override
        public int setString(long position, String str) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a clob is not supported");
        }

        @Override
        public int setString(long position, String str, int offset, int length) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a clob is not supported");
        }

        @Override
        public OutputStream setAsciiStream(long position) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a clob is not supported");
        }

        @Override
        public Writer setCharacterStream(long position) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a clob is not supported");
        }

        @Override
        public void truncate(long length) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a clob is not supported");
        }

        @Override
        public void free() throws SQLException {
            this.swapOpenStream(null);
        }

        @Override
        public Reader getCharacterStream(long position, long length) throws SQLException {
            this.checkPosition(position, length);
            return this.swapOpenStream(new StringReader(this.getSubString(position, (int)length)));
        }

        @Override
        public void close() {
            this.swapOpenStream(null);
        }
    }

    private static class AthenaArray
    implements Array,
    Closeable {
        private final String[] elements;
        private ResultSet openResultSet;

        AthenaArray(String[] elements) {
            this.elements = elements;
            this.openResultSet = null;
        }

        private ResultSet swapOpenResultSet(ResultSet resultSet) {
            if (this.openResultSet != null) {
                try {
                    this.openResultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.openResultSet = resultSet;
            return resultSet;
        }

        @Override
        public String getBaseTypeName() throws SQLException {
            return AthenaDataType.VARCHAR.athenaName();
        }

        @Override
        public int getBaseType() throws SQLException {
            return AthenaDataType.VARCHAR.jdbcType();
        }

        @Override
        public Object getArray() throws SQLException {
            return this.elements;
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) throws SQLException {
            throw new SQLFeatureNotSupportedException("Type mappings are not supported for Array");
        }

        @Override
        public Object getArray(long index, int count) throws SQLException {
            if (index > Integer.MAX_VALUE) {
                throw new SQLFeatureNotSupportedException(String.format("Array indexes larger than %d are not supported", Integer.MAX_VALUE));
            }
            if (index < 1L) {
                throw new IllegalArgumentException(String.format("Invalid array index: %d", index));
            }
            if (index - 1L + (long)count > (long)this.elements.length) {
                throw new IllegalArgumentException(String.format("Invalid array index: %d", index - 1L + (long)count));
            }
            if (count < 1) {
                throw new IllegalArgumentException(String.format("Invalid element count: %d", count));
            }
            return Arrays.copyOfRange(this.elements, (int)index - 1, (int)index - 1 + count);
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw new SQLFeatureNotSupportedException("Type mappings are not supported for Array");
        }

        private ResultSet toResultSet(String[] elements, int incrementIndexBy) throws SQLException {
            final Iterator iterator = IntStream.range(0, elements.length).mapToObj(i -> Pair.of((Object)String.valueOf(i + incrementIndexBy), (Object)elements[i])).iterator();
            ArrayList<Object> columnInfos = new ArrayList<Object>();
            columnInfos.add(ColumnInfo.builder().type(this.getBaseTypeName()).label("INDEX").name("INDEX").precision(Integer.valueOf(65535)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build());
            columnInfos.add(ColumnInfo.builder().type(this.getBaseTypeName()).label("VALUE").name("VALUE").precision(Integer.valueOf(65535)).scale(Integer.valueOf(0)).nullable(ColumnNullable.NULLABLE).caseSensitive(Boolean.valueOf(false)).build());
            ResultSetMetadata metaData = (ResultSetMetadata)ResultSetMetadata.builder().columnInfo(columnInfos).build();
            IteratorResultSetBase<Pair<String, String>> resultSet = new IteratorResultSetBase<Pair<String, String>>(metaData){

                @Override
                protected Iterator<Pair<String, String>> iterator() {
                    return iterator;
                }

                @Override
                protected String stringValue(Pair<String, String> row, int columnIndex) {
                    switch (columnIndex) {
                        case 1: {
                            return (String)row.left();
                        }
                        case 2: {
                            return (String)row.right();
                        }
                    }
                    return null;
                }
            };
            return this.swapOpenResultSet(resultSet);
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.toResultSet((String[])this.getArray(), 1);
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
            throw new SQLFeatureNotSupportedException("Type mappings are not supported for Array");
        }

        @Override
        public ResultSet getResultSet(long index, int count) throws SQLException {
            return this.toResultSet((String[])this.getArray(index, count), (int)index);
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw new SQLFeatureNotSupportedException("Type mappings are not supported for Array");
        }

        @Override
        public void free() throws SQLException {
            this.swapOpenResultSet(null);
        }

        @Override
        public void close() {
            this.swapOpenResultSet(null);
        }
    }

    private static class AthenaBlob
    implements Blob,
    Closeable {
        private final byte[] bytes;
        private Closeable openStream;

        AthenaBlob(byte[] bytes) {
            this.bytes = bytes;
            this.openStream = null;
        }

        private <T extends Closeable> T swapOpenStream(T stream) {
            IoUtils.closeQuietly((AutoCloseable)this.openStream, null);
            this.openStream = stream;
            return stream;
        }

        @Override
        public long length() throws SQLException {
            return this.bytes.length;
        }

        private void checkPosition(long position, long length) throws SQLException {
            if (position > Integer.MAX_VALUE) {
                throw new SQLFeatureNotSupportedException(String.format("Blob positions larger than %d are not supported", Integer.MAX_VALUE));
            }
            if (length > Integer.MAX_VALUE) {
                throw new SQLFeatureNotSupportedException(String.format("Blob lengths larger than %d are not supported", Integer.MAX_VALUE));
            }
            if (position < 1L || position > this.length()) {
                throw new IllegalArgumentException(String.format("Invalid blob position: %d", position));
            }
            if (position + length - 1L > this.length()) {
                throw new IllegalArgumentException(String.format("Invalid blob position: %d", position - 1L + length));
            }
            if (length < 0L) {
                throw new IllegalArgumentException(String.format("Invalid blob length: %d", length));
            }
        }

        @Override
        public byte[] getBytes(long position, int length) throws SQLException {
            this.checkPosition(position, length);
            int from = (int)position - 1;
            int to = (int)position - 1 + length;
            return Arrays.copyOfRange(this.bytes, from, to);
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            return this.swapOpenStream(new ByteArrayInputStream(this.bytes));
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            this.checkPosition(start, 0L);
            int i = (int)start - 1;
            while ((long)i < this.length() - (long)pattern.length + 1L) {
                boolean match = true;
                for (int j = 0; j < pattern.length; ++j) {
                    if (this.bytes[i + j] == pattern[j]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    return i + 1;
                }
                ++i;
            }
            return -1L;
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            byte[] needle = pattern.getBytes(1L, (int)pattern.length());
            return this.position(needle, start);
        }

        @Override
        public int setBytes(long position, byte[] bytes) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a blob is not supported");
        }

        @Override
        public int setBytes(long position, byte[] bytes, int offset, int length) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a blob is not supported");
        }

        @Override
        public OutputStream setBinaryStream(long position) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a blob is not supported");
        }

        @Override
        public void truncate(long length) throws SQLException {
            throw new SQLFeatureNotSupportedException("Updating a blob is not supported");
        }

        @Override
        public void free() throws SQLException {
            this.swapOpenStream(null);
        }

        @Override
        public InputStream getBinaryStream(long position, long length) throws SQLException {
            this.checkPosition(position, length);
            return this.swapOpenStream(new ByteArrayInputStream(this.getBytes(position, (int)length)));
        }

        @Override
        public void close() {
            this.swapOpenStream(null);
        }
    }
}

