/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.configuration;

import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.slf4j.event.Level;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.model.S3AclOption;
import software.amazon.awssdk.utils.StringUtils;

public final class ConnectionParameters {
    public static final ConnectionParameter<String> WORK_GROUP_PARAMETER = ConnectionParameter.builder().name("WorkGroup").defaultValue("primary").build();
    public static final ConnectionParameter<Region> REGION_PARAMETER = ConnectionParameter.builder().name("Region").deprecatedAlias("AwsRegion").valueConverter(Region::of).build();
    public static final ConnectionParameter<String> CATALOG_PARAMETER = ConnectionParameter.builder().name("Catalog").defaultValue("AwsDataCatalog").build();
    public static final ConnectionParameter<String> DATABASE_PARAMETER = ConnectionParameter.builder().name("Database").alias("Schema").defaultValue("default").build();
    public static final ConnectionParameter<String> CREDENTIALS_PROVIDER_PARAMETER = ConnectionParameter.builder().name("CredentialsProvider").deprecatedAlias("AWSCredentialsProviderClass").build();
    public static final ConnectionParameter<String[]> CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER = ConnectionParameter.builder().name("CredentialsProviderArguments").deprecatedAliases(Arrays.asList("AwsCredentialsProviderArguments", "aws_credentials_provider_arguments")).valueConverter(ConnectionParameters::parseCredentialsProviderArguments).build();
    public static final ConnectionParameter<String> USER_PARAMETER = ConnectionParameter.builder().name("User").alias("AccessKeyId").deprecatedAlias("UID").build();
    public static final ConnectionParameter<String> PASSWORD_PARAMETER = ConnectionParameter.builder().name("Password").alias("SecretAccessKey").deprecatedAlias("PWD").isSecret(true).build();
    public static final ConnectionParameter<String> OUTPUT_LOCATION_PARAMETER = ConnectionParameter.builder().name("OutputLocation").deprecatedAlias("S3OutputLocation").build();
    public static final ConnectionParameter<String> ENCRYPTION_OPTION_PARAMETER = ConnectionParameter.builder().name("EncryptionOption").deprecatedAlias("S3OutputEncOption").build();
    public static final ConnectionParameter<String> EXPECTED_BUCKET_OWNER_PARAMETER = ConnectionParameter.builder().name("ExpectedBucketOwner").build();
    public static final ConnectionParameter<String> ACL_OPTION_PARAMETER = ConnectionParameter.builder().name("AclOption").valueConverter(rawValue -> {
        S3AclOption value = S3AclOption.fromValue((String)rawValue);
        if (value.equals((Object)S3AclOption.UNKNOWN_TO_SDK_VERSION)) {
            throw new IllegalArgumentException(String.format("%s is not a valid S3 ACL option.", rawValue));
        }
        return value.toString();
    }).build();
    public static final ConnectionParameter<String> KMS_KEY_PARAMETER = ConnectionParameter.builder().name("KmsKey").deprecatedAlias("S3OutputEncKMSKey").build();
    public static final ConnectionParameter<Integer> FETCH_SIZE_PARAMETER = ConnectionParameter.builder().name("FetchSize").deprecatedAlias("RowsToFetchPerBlock").defaultValue(0).valueConverter(ConnectionParameters::parseFetchSize).build();
    public static final ConnectionParameter<Duration> MIN_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER = ConnectionParameter.builder().name("MinQueryExecutionPollingIntervalMillis").deprecatedAlias("MinQueryExecutionPollingInterval").defaultValue(Duration.ofMillis(100L)).valueConverter(ConnectionParameters::parseMinQueryExecutionPollingIntervalMillis).build();
    public static final ConnectionParameter<Duration> MAX_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER = ConnectionParameter.builder().name("MaxQueryExecutionPollingIntervalMillis").deprecatedAlias("MaxQueryExecutionPollingInterval").defaultValue(Duration.ofSeconds(5L)).valueConverter(ConnectionParameters::parseMaxQueryExecutionPollingIntervalMillis).build();
    public static final ConnectionParameter<Long> QUERY_EXECUTION_POLLING_INTERVAL_MULTIPLIER_PARAMETER = ConnectionParameter.builder().name("QueryExecutionPollingIntervalMultiplier").defaultValue(2L).valueConverter(ConnectionParameters::parseQueryExecutionPollingIntervalMultiplier).build();
    public static final ConnectionParameter<Boolean> CONNECTION_TEST_PARAMETER = ConnectionParameter.builder().name("ConnectionTest").defaultValue(true).valueConverter(ConnectionParameters::parseConnectionTest).build();
    public static final ConnectionParameter<String> ATHENA_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("AthenaEndpoint").alias("Endpoint").deprecatedAlias("EndpointOverride").build();
    public static final ConnectionParameter<String> ATHENA_STREAMING_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("AthenaStreamingEndpoint").alias("StreamingEndpoint").deprecatedAlias("StreamingEndpointOverride").build();
    public static final ConnectionParameter<String> S3_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("S3Endpoint").build();
    public static final ConnectionParameter<String> STS_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("StsEndpoint").deprecatedAlias("StsEndpointOverride").build();
    public static final ConnectionParameter<String> LAKE_FORMATION_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("LakeFormationEndpoint").deprecatedAlias("LfEndpointOverride").build();
    public static final ConnectionParameter<String> SSO_OIDC_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("SsoOidcEndpoint").build();
    public static final ConnectionParameter<String> SSO_ADMIN_ENDPOINT_PARAMETER = ConnectionParameter.builder().name("SsoAdminEndpoint").build();
    public static final ConnectionParameter<String> HOST = ConnectionParameter.builder().name("Host").build();
    public static final ConnectionParameter<Level> LOG_LEVEL_PARAMETER = ConnectionParameter.builder().name("LogLevel").defaultValue(Level.TRACE).valueConverter(ConnectionParameters::parseLoglevel).build();
    public static final ConnectionParameter<Path> LOG_PATH_PARAMETER = ConnectionParameter.builder().name("LogPath").valueConverter(ConnectionParameters::parseLogPath).build();
    public static final ConnectionParameter<Integer> NUM_RETRIES_PARAMETER = ConnectionParameter.builder().name("NumRetries").deprecatedAliases(Arrays.asList("MaxErrorRetry", "max_error_retries")).valueConverter(ConnectionParameters::parseNumRetries).build();
    public static final ConnectionParameter<Duration> NETWORK_TIMEOUT_MILLIS = ConnectionParameter.builder().name("NetworkTimeoutMillis").valueConverter(value -> {
        Integer timeoutMillis = ConnectionParameters.stringToInt(value);
        if (timeoutMillis == null || timeoutMillis < 0) {
            throw new IllegalArgumentException(String.format("Invalid network timeout: \"%s\" (expected a non-negative integer)", value));
        }
        return Duration.ofMillis(timeoutMillis.intValue());
    }).build();
    public static final ConnectionParameter<String> PROXY_HOST_PARAMETER = ConnectionParameter.builder().name("ProxyHost").build();
    public static final ConnectionParameter<Integer> PROXY_PORT_PARAMETER = ConnectionParameter.builder().name("ProxyPort").valueConverter(ConnectionParameters::parseProxyPortNumber).build();
    public static final ConnectionParameter<String> PROXY_USERNAME_PARAMETER = ConnectionParameter.builder().name("ProxyUsername").deprecatedAlias("ProxyUID").build();
    public static final ConnectionParameter<String> PROXY_PASSWORD_PARAMETER = ConnectionParameter.builder().name("ProxyPassword").deprecatedAlias("ProxyPWD").isSecret(true).build();
    public static final ConnectionParameter<Set<String>> PROXY_EXEMPT_HOSTS_PARAMETER = ConnectionParameter.builder().name("ProxyExemptHosts").alias("NonProxyHosts").valueConverter(ConnectionParameters::parseProxyExemptHosts).build();
    public static final ConnectionParameter<Boolean> PROXY_ENABLED_FOR_IDP_PARAMETER = ConnectionParameter.builder().name("ProxyEnabledForIdP").alias("UseProxyForIdP").defaultValue(false).valueConverter(ConnectionParameters::parseProxyEnabledForIdP).build();
    public static final ConnectionParameter<Integer> ROLE_SESSION_DURATION_PARAMETER = ConnectionParameter.builder().name("RoleSessionDuration").deprecatedAlias("Duration").valueConverter(ConnectionParameters::parseRoleSessionDuration).build();
    public static final ConnectionParameter<Integer> IDP_RESPONSE_TIMEOUT = ConnectionParameter.builder().name("IdpResponseTimeout").deprecatedAlias("idp_response_timeout").valueConverter(ConnectionParameters::parseIntegerParameter).build();
    public static final ConnectionParameter<String> SSO_LOGIN_URL = ConnectionParameter.builder().name("SsoLoginUrl").deprecatedAlias("login_url").build();
    public static final ConnectionParameter<Integer> LISTEN_PORT = ConnectionParameter.builder().name("ListenPort").deprecatedAlias("listen_port").valueConverter(ConnectionParameters::parseIntegerParameter).build();
    public static final ConnectionParameter<String> PREFERRED_ROLE_PARAMETER = ConnectionParameter.builder().name("PreferredRole").deprecatedAlias("preferred_role").build();
    public static final ConnectionParameter<Boolean> LAKE_FORMATION_ENABLED_PARAMETER = ConnectionParameter.builder().name("LakeFormationEnabled").defaultValue(false).valueConverter(ConnectionParameters::parseLakeFormationEnabled).build();
    public static final ConnectionParameter<String> APPLICATION_NAME_PARAMETER = ConnectionParameter.builder().name("ApplicationName").build();
    public static final ConnectionParameter<Boolean> ENABLE_RESULT_REUSE_BY_AGE_PARAMETER = ConnectionParameter.builder().name("EnableResultReuseByAge").valueConverter(ConnectionParameters::parseEnableResultReuseByAge).build();
    public static final ConnectionParameter<Integer> MAX_RESULT_REUSE_AGE_IN_MINUTES_PARAMETER = ConnectionParameter.builder().name("MaxResultReuseAgeInMinutes").valueConverter(ConnectionParameters::parseMaxResultReuseAgeInMinutes).build();
    public static final ConnectionParameter<String> RESULT_FETCHER = ConnectionParameter.builder().name("ResultFetcher").defaultValue("auto").build();
    public static final ConnectionParameter<String> IDP_HOST_NAME = ConnectionParameter.builder().name("IdpHostName").aliases(Arrays.asList("OktaHostName", "PingHostName", "AdfsHostName", "IdP_Host")).build();
    public static final ConnectionParameter<Integer> IDP_PORT_NUMBER = ConnectionParameter.builder().name("IdpPortNumber").aliases(Arrays.asList("PingPortNumber", "AdfsPortNumber", "IdP_Port")).valueConverter(ConnectionParameters::parseIdpPortNumber).build();
    public static final ConnectionParameter<String> CUSTOMER_IDC_APPLICATION_ARN = ConnectionParameter.builder().name("CustomerIdcApplicationArn").build();
    public static final ConnectionParameter<String> ACCESS_ROLE_ARN = ConnectionParameter.builder().name("AccessRoleArn").build();
    public static final ConnectionParameter<Set<String>> LEGACY_MODES_PARAMETER = ConnectionParameter.builder().name("LegacyModes").valueConverter(ConnectionParameters::parseLegacyModes).build();
    public static final ConnectionParameter<String> JWT_ROLE_SESSION_NAME_PARAMETER = ConnectionParameter.builder().name("JwtRoleSessionName").deprecatedAlias("role_session_name").build();
    public static final ConnectionParameter<String> JWT_WEB_IDENTITY_TOKEN_PARAMETER = ConnectionParameter.builder().name("JwtWebIdentityToken").deprecatedAlias("web_identity_token").build();
    private static final Set<ConnectionParameter<?>> ALL_PARAMETERS = new CopyOnWriteArraySet();

    static void registerConnectionParameter(ConnectionParameter<?> parameter) {
        ALL_PARAMETERS.add(parameter);
    }

    public static void registerConnectionParameters(Collection<ConnectionParameter<?>> parameters) {
        ALL_PARAMETERS.addAll(parameters);
    }

    static void deregisterConnectionParameter(ConnectionParameter<?> parameter) {
        ALL_PARAMETERS.remove(parameter);
    }

    public static Collection<ConnectionParameter<?>> connectionParameters() {
        return Collections.unmodifiableCollection(ALL_PARAMETERS);
    }

    public static void checkIfPresentAndThrow(List<ConnectionParameter<?>> required, Map<ConnectionParameter<?>, String> parameters) {
        ArrayList<String> errors = new ArrayList<String>();
        for (ConnectionParameter<?> p : required) {
            Optional<?> result = p.findValue(parameters);
            if (result.isPresent()) continue;
            errors.add(String.format("Missing required connection parameter: %s.", p.name()));
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static Integer parseFetchSize(String value) {
        Integer fetchSize = ConnectionParameters.stringToInt(value);
        if (fetchSize == null || fetchSize < 0 || fetchSize > 1000000) {
            throw new IllegalArgumentException(String.format("Invalid fetch size: \"%s\" (expected an integer between 0 and 1000000)", value));
        }
        return fetchSize;
    }

    private static Duration parseMinQueryExecutionPollingIntervalMillis(String value) {
        Long minQueryExecutionPollingIntervalMillis = ConnectionParameters.stringToLong(value);
        if (minQueryExecutionPollingIntervalMillis == null || minQueryExecutionPollingIntervalMillis <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid minimum query execution polling interval: \"%s\" (expected a positive integer)", value));
        }
        return Duration.ofMillis(minQueryExecutionPollingIntervalMillis);
    }

    private static Duration parseMaxQueryExecutionPollingIntervalMillis(String value) {
        Long maxQueryExecutionPollingIntervalMillis = ConnectionParameters.stringToLong(value);
        if (maxQueryExecutionPollingIntervalMillis == null || maxQueryExecutionPollingIntervalMillis <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid maximum query execution polling interval: \"%s\" (expected a positive integer)", value));
        }
        return Duration.ofMillis(maxQueryExecutionPollingIntervalMillis);
    }

    private static Long parseQueryExecutionPollingIntervalMultiplier(String value) {
        Long queryExecutionPollingIntervalMultiplier = ConnectionParameters.stringToLong(value);
        if (queryExecutionPollingIntervalMultiplier == null || queryExecutionPollingIntervalMultiplier < 2L) {
            throw new IllegalArgumentException(String.format("Invalid query execution polling interval multiplier: \"%s\" (expected an integer greater than or equal to 2)", value));
        }
        return queryExecutionPollingIntervalMultiplier;
    }

    private static Boolean parseConnectionTest(String value) {
        Boolean connectionTest = ConnectionParameters.stringToBoolean(value);
        if (connectionTest == null) {
            throw new IllegalArgumentException(String.format("Invalid value for connection test: \"%s\"", value));
        }
        return connectionTest;
    }

    private static Integer parseNumRetries(String value) {
        Integer numRetries = ConnectionParameters.stringToInt(value);
        if (numRetries == null || numRetries < 0) {
            throw new IllegalArgumentException(String.format("Invalid number of retries: \"%s\" (expected a non-negative integer)", value));
        }
        return numRetries;
    }

    private static Integer stringToInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long stringToLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Boolean stringToBoolean(String value) {
        if (value != null && (value.equalsIgnoreCase("true") || value.equals("1"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equals("0"))) {
            return false;
        }
        return null;
    }

    private static Level parseLoglevel(String value) {
        if (value == null || value.isEmpty()) {
            return Level.TRACE;
        }
        if (value.equalsIgnoreCase("off")) {
            return null;
        }
        try {
            return Level.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid log level: \"%s\"", value));
        }
    }

    private static Path parseLogPath(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Paths.get(value, new String[0]);
    }

    private static Integer parseIntegerParameter(String value) {
        Integer converted = ConnectionParameters.stringToInt(value);
        if (converted == null || converted < 0) {
            throw new IllegalArgumentException(String.format("Failed to parse \"%s\" value as integer.", value));
        }
        return converted;
    }

    private static Integer parseProxyPortNumber(String value) {
        Integer proxyPortNumber = ConnectionParameters.stringToInt(value);
        if (proxyPortNumber == null || proxyPortNumber < 0) {
            throw new IllegalArgumentException(String.format("Invalid proxy port: \"%s\" (expected a non-negative integer)", value));
        }
        return proxyPortNumber;
    }

    private static Integer parseIdpPortNumber(String value) {
        Integer idpPortNumber = ConnectionParameters.stringToInt(value);
        if (idpPortNumber == null || idpPortNumber < 0) {
            throw new IllegalArgumentException(String.format("Invalid IdP port: \"%s\" (expected a non-negative integer)", value));
        }
        return idpPortNumber;
    }

    private static Set<String> parseProxyExemptHosts(String proxyExemptHosts) {
        if (StringUtils.isBlank((CharSequence)proxyExemptHosts)) {
            return Collections.emptySet();
        }
        return Arrays.stream(proxyExemptHosts.split("\\|")).map(String::toLowerCase).map(s -> s.replace("*", ".*?")).collect(Collectors.toSet());
    }

    private static String[] parseCredentialsProviderArguments(String value) {
        if (!StringUtils.isBlank((CharSequence)value)) {
            return value.split(",");
        }
        return new String[0];
    }

    public static Integer parseRoleSessionDuration(String value) {
        Integer roleSessionDurationSeconds = ConnectionParameters.stringToInt(value);
        if (roleSessionDurationSeconds == null || roleSessionDurationSeconds < 900 || roleSessionDurationSeconds > 43200) {
            throw new IllegalArgumentException(String.format("Invalid role session duration: \"%s\" (expected an integer between 900 and 43200)", value));
        }
        return roleSessionDurationSeconds;
    }

    private static Boolean parseLakeFormationEnabled(String value) {
        Boolean lakeFormationEnabled = ConnectionParameters.stringToBoolean(value);
        if (lakeFormationEnabled == null) {
            throw new IllegalArgumentException(String.format("Invalid value for Lake Formation enabled: \"%s\"", value));
        }
        return lakeFormationEnabled;
    }

    private static Boolean parseEnableResultReuseByAge(String value) {
        Boolean enableResultReuseByAge = ConnectionParameters.stringToBoolean(value);
        if (enableResultReuseByAge == null) {
            throw new IllegalArgumentException(String.format("Invalid value for enable result reuse by age: \"%s\" (expected 'true' (any capitalization), 'false' (any capitalization), '0' or '1'", value));
        }
        return enableResultReuseByAge;
    }

    private static Integer parseMaxResultReuseAgeInMinutes(String value) {
        Integer maxResultReuseAgeInMinutes = ConnectionParameters.stringToInt(value);
        if (maxResultReuseAgeInMinutes == null || maxResultReuseAgeInMinutes < 0) {
            throw new IllegalArgumentException(String.format("Invalid maximum result reuse age in minutes: \"%s\" (expected a non-negative integer)", value));
        }
        return maxResultReuseAgeInMinutes;
    }

    private static Boolean parseProxyEnabledForIdP(String value) {
        if (value != null && (value.equalsIgnoreCase("true") || value.equals("1"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equals("0"))) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Invalid value for proxy enabled for IdP: \"%s\"", value));
    }

    private static Set<String> parseLegacyModes(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptySet();
        }
        return Arrays.stream(value.split(",")).map(String::toLowerCase).collect(Collectors.toSet());
    }

    static {
        ConnectionParameters.registerConnectionParameter(WORK_GROUP_PARAMETER);
        ConnectionParameters.registerConnectionParameter(REGION_PARAMETER);
        ConnectionParameters.registerConnectionParameter(CATALOG_PARAMETER);
        ConnectionParameters.registerConnectionParameter(DATABASE_PARAMETER);
        ConnectionParameters.registerConnectionParameter(CREDENTIALS_PROVIDER_PARAMETER);
        ConnectionParameters.registerConnectionParameter(CREDENTIALS_PROVIDER_ARGUMENTS_PARAMETER);
        ConnectionParameters.registerConnectionParameter(USER_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PASSWORD_PARAMETER);
        ConnectionParameters.registerConnectionParameter(IDP_RESPONSE_TIMEOUT);
        ConnectionParameters.registerConnectionParameter(SSO_LOGIN_URL);
        ConnectionParameters.registerConnectionParameter(LISTEN_PORT);
        ConnectionParameters.registerConnectionParameter(IDP_HOST_NAME);
        ConnectionParameters.registerConnectionParameter(IDP_PORT_NUMBER);
        ConnectionParameters.registerConnectionParameter(ROLE_SESSION_DURATION_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PREFERRED_ROLE_PARAMETER);
        ConnectionParameters.registerConnectionParameter(OUTPUT_LOCATION_PARAMETER);
        ConnectionParameters.registerConnectionParameter(ENCRYPTION_OPTION_PARAMETER);
        ConnectionParameters.registerConnectionParameter(EXPECTED_BUCKET_OWNER_PARAMETER);
        ConnectionParameters.registerConnectionParameter(ACL_OPTION_PARAMETER);
        ConnectionParameters.registerConnectionParameter(KMS_KEY_PARAMETER);
        ConnectionParameters.registerConnectionParameter(FETCH_SIZE_PARAMETER);
        ConnectionParameters.registerConnectionParameter(MIN_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER);
        ConnectionParameters.registerConnectionParameter(MAX_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER);
        ConnectionParameters.registerConnectionParameter(QUERY_EXECUTION_POLLING_INTERVAL_MULTIPLIER_PARAMETER);
        ConnectionParameters.registerConnectionParameter(CONNECTION_TEST_PARAMETER);
        ConnectionParameters.registerConnectionParameter(ATHENA_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(ATHENA_STREAMING_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(S3_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(SSO_OIDC_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(SSO_ADMIN_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(NUM_RETRIES_PARAMETER);
        ConnectionParameters.registerConnectionParameter(NETWORK_TIMEOUT_MILLIS);
        ConnectionParameters.registerConnectionParameter(LOG_LEVEL_PARAMETER);
        ConnectionParameters.registerConnectionParameter(LOG_PATH_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PROXY_HOST_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PROXY_PORT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PROXY_USERNAME_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PROXY_PASSWORD_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PROXY_EXEMPT_HOSTS_PARAMETER);
        ConnectionParameters.registerConnectionParameter(PROXY_ENABLED_FOR_IDP_PARAMETER);
        ConnectionParameters.registerConnectionParameter(LAKE_FORMATION_ENABLED_PARAMETER);
        ConnectionParameters.registerConnectionParameter(LAKE_FORMATION_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(STS_ENDPOINT_PARAMETER);
        ConnectionParameters.registerConnectionParameter(APPLICATION_NAME_PARAMETER);
        ConnectionParameters.registerConnectionParameter(ENABLE_RESULT_REUSE_BY_AGE_PARAMETER);
        ConnectionParameters.registerConnectionParameter(MAX_RESULT_REUSE_AGE_IN_MINUTES_PARAMETER);
        ConnectionParameters.registerConnectionParameter(RESULT_FETCHER);
        ConnectionParameters.registerConnectionParameter(LEGACY_MODES_PARAMETER);
        ConnectionParameters.registerConnectionParameter(CUSTOMER_IDC_APPLICATION_ARN);
        ConnectionParameters.registerConnectionParameter(ACCESS_ROLE_ARN);
        ConnectionParameters.registerConnectionParameter(JWT_ROLE_SESSION_NAME_PARAMETER);
        ConnectionParameters.registerConnectionParameter(JWT_WEB_IDENTITY_TOKEN_PARAMETER);
    }
}

