/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;

abstract class IdpCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(IdpCredentialsProvider.class);

    IdpCredentialsProvider() {
    }

    protected static CloseableHttpClient createHttpClient(Map<ConnectionParameter<?>, String> parameters) {
        return IdpCredentialsProvider.createHttpClient(parameters, BasicCredentialsProvider::new, RequestConfig::custom);
    }

    protected static CloseableHttpClient createHttpClient(Map<ConnectionParameter<?>, String> parameters, Supplier<CredentialsProvider> credentialsProviderFactory, Supplier<RequestConfig.Builder> requestConfigBuilderFactory) {
        RequestConfig.Builder rc = requestConfigBuilderFactory.get().setSocketTimeout(60000).setConnectTimeout(60000).setExpectContinueEnabled(false).setCookieSpec("standard");
        HttpClientBuilder builder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).useSystemProperties();
        Optional<Boolean> proxyEnabledForIdP = ConnectionParameters.PROXY_ENABLED_FOR_IDP_PARAMETER.findValue(parameters);
        if (proxyEnabledForIdP.isPresent() && proxyEnabledForIdP.get().booleanValue()) {
            Optional<String> proxyHost = ConnectionParameters.PROXY_HOST_PARAMETER.findValue(parameters);
            Optional<Integer> proxyPort = ConnectionParameters.PROXY_PORT_PARAMETER.findValue(parameters);
            if (proxyHost.isPresent() && proxyPort.isPresent()) {
                String[] schemeAndHost = IdpCredentialsProvider.getSchemeAndHost(proxyHost.get());
                rc.setProxy(new HttpHost(schemeAndHost[1], proxyPort.get().intValue(), schemeAndHost[0]));
                Optional<String> proxyUsername = ConnectionParameters.PROXY_USERNAME_PARAMETER.findValue(parameters);
                Optional<String> proxyPassword = ConnectionParameters.PROXY_PASSWORD_PARAMETER.findValue(parameters);
                if (proxyUsername.isPresent() && proxyPassword.isPresent()) {
                    CredentialsProvider credentialsProvider = credentialsProviderFactory.get();
                    credentialsProvider.setCredentials(new AuthScope(schemeAndHost[1], proxyPort.get().intValue()), (Credentials)new UsernamePasswordCredentials(proxyUsername.get(), proxyPassword.get()));
                    builder.setDefaultCredentialsProvider(credentialsProvider);
                }
            }
        }
        builder.setDefaultRequestConfig(rc.build());
        return builder.build();
    }

    protected void validateSsoURL(String urlString) throws IOException {
        logger.info(String.format("Validating URL: %s", urlString), new Object[0]);
        try {
            URI url = URI.create(urlString);
            if (!url.toURL().getProtocol().equalsIgnoreCase("https")) {
                throw new IOException("Expected https protocol in SSO URL.");
            }
        }
        catch (IllegalArgumentException | MalformedURLException ex) {
            throw new IOException("Malformed SSO URL. " + ex.getMessage(), ex);
        }
    }

    protected Optional<String> findValueInNameValuePairs(String name, List<NameValuePair> list) {
        for (NameValuePair pair : list) {
            if (!name.equals(pair.getName())) continue;
            return Optional.of(pair.getValue());
        }
        return Optional.empty();
    }

    private static String[] getSchemeAndHost(String host) {
        if (host.startsWith("http://") || host.startsWith("https://")) {
            return host.split("://");
        }
        return new String[]{"https", host};
    }
}

