/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.SamlCredentialsProvider;
import com.amazon.athena.jdbc.authentication.http.BrowserAuthenticationServer;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.NameValuePair;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;

public class BrowserSamlCredentialsProvider
extends SamlCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(BrowserSamlCredentialsProvider.class);
    private static final String SAML_RESPONSE_PARAM_NAME = "SAMLResponse";
    private String loginUrl;
    private final int idpResponseTimeout;
    private final Desktop desktop;
    private final BrowserAuthenticationServer server;

    private BrowserSamlCredentialsProvider(String loginUrl, String preferredRole, Integer roleSessionDuration, Region region, AssumeRoleWithSamlRequest.Builder assumeRoleRequestFactory, StsClientBuilder stsClientFactory, AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleRequestFactory, LakeFormationClientBuilder lfClientFactory, boolean lakeFormationEnabled, int idpResponseTimeout, int listenPort, Desktop desktop, BrowserAuthenticationServer server, Map<ConnectionParameter<?>, String> parameters) {
        super(assumeRoleRequestFactory, assumeDecoratedRoleRequestFactory, stsClientFactory, lfClientFactory, null, null, preferredRole, roleSessionDuration, region, lakeFormationEnabled, parameters);
        this.loginUrl = loginUrl;
        this.idpResponseTimeout = idpResponseTimeout;
        this.desktop = desktop == null ? Desktop.getDesktop() : desktop;
        this.server = server == null ? new BrowserAuthenticationServer(listenPort) : server;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String getSamlAssertion() {
        try {
            this.validateSsoURL(this.loginUrl);
            return this.authenticate();
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.getMessage(), ex);
        }
    }

    private String authenticate() throws IOException {
        Future<List<NameValuePair>> future = this.server.listenForResponse();
        try {
            URI url = URI.create(this.loginUrl);
            this.desktop.browse(url);
            List<NameValuePair> response = future.get(this.idpResponseTimeout, TimeUnit.SECONDS);
            Optional<String> receivedSaml = this.findValueInNameValuePairs(SAML_RESPONSE_PARAM_NAME, response);
            if (!receivedSaml.isPresent() || receivedSaml.get().isEmpty()) {
                throw new AuthenticationException("SAML assertion is not found or empty.");
            }
            String string = receivedSaml.get();
            return string;
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw new AuthenticationException("Couldn't fetch code within timeout window.");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.debug("Main thread got interrupted: {}", ex.getMessage());
            throw new AuthenticationException("Main thread got interrupted.", ex);
        }
        catch (ExecutionException ex) {
            logger.debug("Server thread throw an exception: {}", ex.getMessage());
            throw new AuthenticationException(ex.getMessage());
        }
        finally {
            logger.trace("Shutdown listening server.", new Object[0]);
            this.server.shutdownServer();
        }
    }

    public static class Builder {
        private String loginUrl;
        private String preferredRole;
        private Integer roleSessionDuration;
        private Integer idpResponseTimeout;
        private Integer listenPort;
        private Desktop desktop;
        private Region region;
        private BrowserAuthenticationServer server;
        private boolean lakeFormationEnabled;
        private AssumeRoleWithSamlRequest.Builder stsAssumeRoleFactory;
        private AssumeDecoratedRoleWithSamlRequest.Builder lfAssumeRoleFactory;
        private StsClientBuilder stsClientFactory;
        private LakeFormationClientBuilder lfClientFactory;
        private Map<ConnectionParameter<?>, String> parameters;

        public Builder preferredRole(String preferredRole) {
            this.preferredRole = preferredRole;
            return this;
        }

        public Builder roleSessionDuration(Integer roleSessionDuration) {
            this.roleSessionDuration = roleSessionDuration;
            return this;
        }

        public Builder loginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
            return this;
        }

        public Builder idpResponseTimeout(Integer idpResponseTimeout) {
            this.idpResponseTimeout = idpResponseTimeout;
            return this;
        }

        public Builder listenPort(Integer listenPort) {
            this.listenPort = listenPort;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder lakeFormationEnabled(boolean lakeFormationEnabled) {
            this.lakeFormationEnabled = lakeFormationEnabled;
            return this;
        }

        public Builder connectionParameters(Map<ConnectionParameter<?>, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        Builder assumeRoleWithSamlRequestFactory(AssumeRoleWithSamlRequest.Builder factory) {
            this.stsAssumeRoleFactory = factory;
            return this;
        }

        Builder assumeDecoratedRoleWithSamlRequestFactory(AssumeDecoratedRoleWithSamlRequest.Builder factory) {
            this.lfAssumeRoleFactory = factory;
            return this;
        }

        Builder stsClientBuilder(StsClientBuilder factory) {
            this.stsClientFactory = factory;
            return this;
        }

        Builder lakeFormationClientBuilder(LakeFormationClientBuilder factory) {
            this.lfClientFactory = factory;
            return this;
        }

        Builder server(BrowserAuthenticationServer server) {
            this.server = server;
            return this;
        }

        Builder browser(Desktop desktop) {
            this.desktop = desktop;
            return this;
        }

        public BrowserSamlCredentialsProvider build() {
            return new BrowserSamlCredentialsProvider(this.loginUrl, this.preferredRole, this.roleSessionDuration, this.region, this.stsAssumeRoleFactory, this.stsClientFactory, this.lfAssumeRoleFactory, this.lfClientFactory, this.lakeFormationEnabled, this.idpResponseTimeout, this.listenPort, this.desktop, this.server, this.parameters);
        }
    }
}

