/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.jdbc.AthenaDatabaseMetaData;
import com.amazon.athena.jdbc.AthenaPreparedStatement;
import com.amazon.athena.jdbc.AthenaStatement;
import com.amazon.athena.jdbc.configuration.ConnectionConfiguration;
import com.amazon.athena.jdbc.support.AutoUnwrap;
import com.amazon.athena.jdbc.support.ClientInfoRecognizedProperties;
import com.amazon.athena.logging.AthenaLogger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Function;
import lombok.NonNull;

public class AthenaConnection
implements Connection,
AutoUnwrap {
    private static final AthenaLogger logger = AthenaLogger.of(AthenaConnection.class);
    private final ConnectionConfiguration configuration;
    private final Function<AthenaConnection, Statement> statementFactory;
    private final DatabaseMetaData databaseMetaData;
    private final Map<String, String> clientInfoProperties;
    private boolean open;

    public AthenaConnection(ConnectionConfiguration configuration) {
        this(configuration, AthenaStatement::new);
    }

    AthenaConnection(ConnectionConfiguration configuration, Function<AthenaConnection, Statement> statementFactory) {
        this.configuration = configuration;
        this.statementFactory = statementFactory;
        this.databaseMetaData = new AthenaDatabaseMetaData(this);
        this.clientInfoProperties = new HashMap<String, String>();
        this.open = true;
    }

    private void ensureOpen() throws SQLException {
        if (!this.open) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.ensureOpen();
        return this.statementFactory.apply(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.ensureOpen();
        return new AthenaPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support stored procedures");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpen();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Only auto commit connections are supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Only auto commit connections are supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support transactions");
    }

    @Override
    public void close() throws SQLException {
        if (this.open) {
            logger.debug("Closing connection", new Object[0]);
            this.configuration.close();
            this.open = false;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        if (readOnly) {
            throw new SQLFeatureNotSupportedException("Read-only mode is not supported");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
        this.configuration.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureOpen();
        return this.configuration.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpen();
        if (level != 0) {
            throw new SQLFeatureNotSupportedException("Athena does not support transactions");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSetType(resultSetType);
        AthenaConnection.checkResultSetConcurrency(resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSetType(resultSetType);
        AthenaConnection.checkResultSetConcurrency(resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    private void checkResultSetType(int resultSetType) throws SQLFeatureNotSupportedException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Only forward-only results sets are supported");
        }
    }

    private static void checkResultSetConcurrency(int resultSetConcurrency) throws SQLFeatureNotSupportedException {
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Only read-only result sets are supported");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support stored procedures");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting a type map is not supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        if (holdability != 2) {
            throw new SQLFeatureNotSupportedException("Holdability other than close cursors at commit is not supported");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support savepoints");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support savepoints");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support transactions");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support savepoints");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        AthenaConnection.checkResultSetHoldability(resultSetHoldability);
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        AthenaConnection.checkResultSetHoldability(resultSetHoldability);
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    private static void checkResultSetHoldability(int resultSetHoldability) throws SQLFeatureNotSupportedException {
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException("Only close cursors at commit result sets are supported");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Athena does not support stored procedures");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating clobs is not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating blobs is not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating nclobs is not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("The SQLXML type is not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.open;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties properties = new Properties();
        this.clientInfoProperties.forEach(properties::setProperty);
        if (value == null) {
            properties.remove(name);
        } else {
            properties.setProperty(name, value);
        }
        this.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(@NonNull Properties properties) throws SQLClientInfoException {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (!this.open) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (String name : properties.stringPropertyNames()) {
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException("This operation could not be performed because the connection was closed", failures);
        }
        this.clientInfoProperties.clear();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (ClientInfoRecognizedProperties.isStandardClientInfoPropertyName(name)) {
                this.clientInfoProperties.put(name, value);
                continue;
            }
            logger.warn("The client info property \"{}\" is unknown and will be ignored", name);
        }
        String applicationName = properties.keySet().stream().map(Object::toString).filter(propertyName -> propertyName.equalsIgnoreCase("ApplicationName")).findFirst().map(properties::getProperty).orElse(null);
        this.configuration.setApplicationName(applicationName);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        return this.clientInfoProperties.get(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        Properties properties = new Properties();
        this.clientInfoProperties.forEach(properties::setProperty);
        return properties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating an array is not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating a struct is not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureOpen();
        this.configuration.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureOpen();
        return this.configuration.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.ensureOpen();
        if (executor != null) {
            logger.warn("The Executor parameter is currently not supported and will be ignored", new Object[0]);
        }
        if (milliseconds > 0) {
            this.configuration.setApiRequestTimeout(Duration.ofMillis(milliseconds));
        } else if (milliseconds == 0) {
            this.configuration.setApiRequestTimeout(ConnectionConfiguration.PRACTICALLY_INFINITE_DURATION);
        } else {
            throw new IllegalArgumentException(String.format("Invalid network timeout: \"%s\" (expected a non-negative integer)", milliseconds));
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureOpen();
        Duration apiRequestTimeout = this.configuration.getApiRequestTimeout();
        if (apiRequestTimeout.equals(ConnectionConfiguration.PRACTICALLY_INFINITE_DURATION)) {
            return 0;
        }
        return Math.toIntExact(apiRequestTimeout.toMillis());
    }

    public AthenaConnection testConnection() throws SQLException {
        if (this.configuration.getConnectionTest()) {
            try (Statement stmt = this.createStatement();){
                stmt.execute("-- Athena JDBC driver connection test\nSELECT 1");
            }
            catch (SQLException e) {
                throw new SQLException(String.format("Connection test failed: %s", e.getMessage()), e);
            }
        }
        return this;
    }

    ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }
}

