/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.error.QueryResultException;
import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.client.results.AsyncQueryResultsFactory;
import com.amazon.athena.client.results.GetQueryResultsStreamQueryResults;
import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.client.results.ResultParserFactory;
import com.amazon.athena.client.results.parsing.GetQueryResultsStreamResponseParser;
import com.amazon.athena.logging.AthenaLogger;
import java.text.ParseException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingAsyncClient;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamRequest;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamResponse;

public class GetQueryResultsStreamQueryResultsFactory
implements AsyncQueryResultsFactory {
    private static final AthenaLogger logger = AthenaLogger.of(GetQueryResultsStreamQueryResultsFactory.class);
    private final AthenaStreamingAsyncClient athenaStreamingClient;
    private final int fetchSize;
    private final Executor executor;
    private final ResultParserFactory resultParserFactory;

    public GetQueryResultsStreamQueryResultsFactory(AthenaStreamingAsyncClient athenaStreamingClient, Executor executor, ResultParserFactory resultParserFactory) {
        this.athenaStreamingClient = athenaStreamingClient;
        this.fetchSize = resultParserFactory.getFetchSize();
        this.executor = executor;
        this.resultParserFactory = resultParserFactory;
    }

    @Override
    public CompletionStage<AsyncQueryResults> create(QueryExecution queryMetadata) {
        logger.debug("Query execution {} loading the first page of {} rows", queryMetadata.queryExecutionId(), this.fetchSize);
        GetQueryResultsStreamRequest request = (GetQueryResultsStreamRequest)GetQueryResultsStreamRequest.builder().maxResults(Integer.valueOf(this.fetchSize)).queryExecutionId(queryMetadata.queryExecutionId()).build();
        GetQueryResultsStreamResponseParser resultParser = this.resultParserFactory.createGetQueryResultsStreamResultRowsParser(queryMetadata);
        return ((CompletableFuture)((CompletableFuture)this.athenaStreamingClient.getQueryResultsStream(request, AsyncResponseTransformer.toBlockingInputStream()).exceptionally(t -> (ResponseInputStream)this.handleRequestFailure(queryMetadata, (Throwable)t))).thenApply(response -> this.parseResponse((ResponseInputStream<GetQueryResultsStreamResponse>)response, queryMetadata, resultParser))).thenApply(resultPage -> new GetQueryResultsStreamQueryResults(this.athenaStreamingClient, this.fetchSize, this.executor, queryMetadata, (ResultPage)resultPage, resultParser));
    }

    private <T> T handleRequestFailure(QueryExecution queryMetadata, Throwable e) {
        logger.warn(String.format("Query execution %s failed loading result page: %s", queryMetadata.queryExecutionId(), e.getMessage()), e);
        throw new CompletionException(new QueryResultException(queryMetadata, String.format("Could not load query results: %s", e.getMessage()), e));
    }

    private ResultPage parseResponse(ResponseInputStream<GetQueryResultsStreamResponse> response, QueryExecution queryMetadata, GetQueryResultsStreamResponseParser resultParser) {
        try {
            ResultPage resultPage = resultParser.parse(response);
            logger.info("Query execution {} loaded the first page, got {} rows (header included), {} more pages", queryMetadata.queryExecutionId(), resultPage.rows().size(), resultPage.nextToken() == null ? "no" : "has");
            if (resultPage.nextToken() != null) {
                logger.trace("Query execution {} loaded the first page, next token is \"{}\"", queryMetadata.queryExecutionId(), resultPage.nextToken());
            }
            return resultPage;
        }
        catch (ParseException e) {
            logger.warn(String.format("Query execution %s failed parsing the first page: %s", queryMetadata.queryExecutionId(), e.getMessage()), e);
            throw new CompletionException(e);
        }
    }
}

