/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.util;

import io.yellowbrick.shaded.org.postgresql.core.Utils;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramFunctions;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.StringPreparation;
import io.yellowbrick.shaded.org.postgresql.util.MD5Digest;
import io.yellowbrick.shaded.org.postgresql.util.PSQLException;
import io.yellowbrick.shaded.org.postgresql.util.PSQLState;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class PasswordUtil {
    private static final int DEFAULT_ITERATIONS = 4096;
    private static final int DEFAULT_SALT_LENGTH = 16;

    private static SecureRandom getSecureRandom() {
        return SecureRandomHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeScramSha256(char[] password, int iterations, byte[] salt) {
        Objects.requireNonNull(password, "password");
        Objects.requireNonNull(salt, "salt");
        if (iterations <= 0) {
            throw new IllegalArgumentException("iterations must be greater than zero");
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException("salt length must be greater than zero");
        }
        try {
            ScramMechanism scramSha256 = ScramMechanism.SCRAM_SHA_256;
            byte[] saltedPassword = ScramFunctions.saltedPassword(scramSha256, StringPreparation.POSTGRESQL_PREPARATION, password, salt, iterations);
            byte[] clientKey = ScramFunctions.clientKey(scramSha256, saltedPassword);
            byte[] storedKey = ScramFunctions.storedKey(scramSha256, clientKey);
            byte[] serverKey = ScramFunctions.serverKey(scramSha256, saltedPassword);
            String string = scramSha256.getName() + "$" + iterations + ":" + Base64.getEncoder().encodeToString(salt) + "$" + Base64.getEncoder().encodeToString(storedKey) + ":" + Base64.getEncoder().encodeToString(serverKey);
            return string;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    public static String encodeScramSha256(char[] password) {
        Objects.requireNonNull(password, "password");
        try {
            byte[] salt = ScramFunctions.salt(16, PasswordUtil.getSecureRandom());
            String string = PasswordUtil.encodeScramSha256(password, 4096, salt);
            return string;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    @Deprecated
    public static String encodeMd5(String user, char[] password) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(password, "password");
        ByteBuffer passwordBytes = null;
        try {
            passwordBytes = StandardCharsets.UTF_8.encode(CharBuffer.wrap(password));
            byte[] userBytes = user.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passwordBytes);
            md.update(userBytes);
            byte[] digest = md.digest();
            byte[] encodedPassword = new byte[35];
            encodedPassword[0] = 109;
            encodedPassword[1] = 100;
            encodedPassword[2] = 53;
            MD5Digest.bytesToHex(digest, encodedPassword, 3);
            String string = new String(encodedPassword, StandardCharsets.UTF_8);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to encode password with MD5", e);
        }
        finally {
            Arrays.fill(password, '\u0000');
            if (passwordBytes != null) {
                if (passwordBytes.hasArray()) {
                    byte[] array = passwordBytes.array();
                    Arrays.fill(array, (byte)0);
                } else {
                    int limit = passwordBytes.limit();
                    for (int i = 0; i < limit; ++i) {
                        passwordBytes.put(i, (byte)0);
                    }
                }
            }
        }
    }

    public static String encodePassword(String user, char[] password, String encryptionType) throws SQLException {
        Objects.requireNonNull(password, "password");
        Objects.requireNonNull(encryptionType, "encryptionType");
        switch (encryptionType) {
            case "md5": {
                return PasswordUtil.encodeMd5(user, password);
            }
            case "on": 
            case "off": 
            case "scram-sha-256": {
                return PasswordUtil.encodeScramSha256(password);
            }
        }
        Arrays.fill(password, '\u0000');
        throw new PSQLException("Unable to determine encryption type: " + encryptionType, PSQLState.SYSTEM_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genAlterUserPasswordSQL(String user, char[] password, String encryptionType) throws SQLException {
        try {
            String encodedPassword = PasswordUtil.encodePassword(user, password, encryptionType);
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER USER ");
            Utils.escapeIdentifier(sb, user);
            sb.append(" PASSWORD '");
            Utils.escapeLiteral(sb, encodedPassword, true);
            sb.append("'");
            String string = sb.toString();
            return string;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    private static class SecureRandomHolder {
        static final SecureRandom INSTANCE = new SecureRandom();

        private SecureRandomHolder() {
        }
    }
}

