/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.util;

import io.yellowbrick.shaded.org.postgresql.util.ByteStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

class ByteBuffersByteStreamWriter
implements ByteStreamWriter {
    private final ByteBuffer[] buffers;
    private final int length;

    ByteBuffersByteStreamWriter(ByteBuffer ... buffers) {
        this.buffers = buffers;
        int length = 0;
        for (ByteBuffer buffer : buffers) {
            length += buffer.remaining();
        }
        this.length = length;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void writeTo(ByteStreamWriter.ByteStreamTarget target) throws IOException {
        boolean allArraysAreAccessible = true;
        for (ByteBuffer buffer : this.buffers) {
            if (buffer.hasArray()) continue;
            allArraysAreAccessible = false;
            break;
        }
        OutputStream os = target.getOutputStream();
        if (allArraysAreAccessible) {
            for (ByteBuffer buffer : this.buffers) {
                os.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            }
            return;
        }
        try (WritableByteChannel c = Channels.newChannel(os);){
            for (ByteBuffer buffer : this.buffers) {
                if (buffer.hasArray()) {
                    os.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                    continue;
                }
                c.write(buffer);
            }
        }
    }
}

