/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.util;

import io.yellowbrick.shaded.org.postgresql.util.ByteStreamWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class ByteBufferByteStreamWriter
implements ByteStreamWriter {
    private final ByteBuffer buf;
    private final int length;

    public ByteBufferByteStreamWriter(ByteBuffer buf) {
        this.buf = buf;
        this.length = buf.remaining();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void writeTo(ByteStreamWriter.ByteStreamTarget target) throws IOException {
        if (this.buf.hasArray()) {
            target.getOutputStream().write(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), this.buf.remaining());
            return;
        }
        try (WritableByteChannel c = Channels.newChannel(target.getOutputStream());){
            c.write(this.buf);
        }
    }
}

