/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.saslprep.SASLprep;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.stringprep.Profile;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScramStringFormatting {
    static final Profile SASL_PREP = new SASLprep();

    private ScramStringFormatting() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    static String toSaslName(@NotNull String value) {
        if (value.isEmpty()) {
            return value;
        }
        char[] originalChars = SASL_PREP.prepareQuery(value.toCharArray());
        int comma = 0;
        int equal = 0;
        for (char c : originalChars) {
            if (',' == c) {
                ++comma;
                continue;
            }
            if ('=' != c) continue;
            ++equal;
        }
        if (comma == 0 && equal == 0) {
            return new String(originalChars);
        }
        char[] saslChars = new char[originalChars.length + comma * 2 + equal * 2];
        int i = 0;
        for (char c : originalChars) {
            if (',' == c) {
                saslChars[i++] = 61;
                saslChars[i++] = 50;
                saslChars[i++] = 67;
                continue;
            }
            if ('=' == c) {
                saslChars[i++] = 61;
                saslChars[i++] = 51;
                saslChars[i++] = 68;
                continue;
            }
            saslChars[i++] = c;
        }
        return new String(saslChars);
    }

    @Nullable
    static String fromSaslName(@Nullable String value) {
        if (null == value || value.isEmpty()) {
            return value;
        }
        int equal = 0;
        char[] orig = value.toCharArray();
        for (int i = 0; i < orig.length; ++i) {
            if (orig[i] == ',') {
                throw new IllegalArgumentException("Invalid ',' character present in saslName");
            }
            if (orig[i] != '=') continue;
            ++equal;
            if (i + 2 > orig.length - 1) {
                throw new IllegalArgumentException("Invalid '=' character present in saslName");
            }
            if (orig[i + 1] == '2' && orig[i + 2] == 'C' || orig[i + 1] == '3' && orig[i + 2] == 'D') continue;
            throw new IllegalArgumentException("Invalid char '=" + orig[i + 1] + orig[i + 2] + "' found in saslName");
        }
        if (equal == 0) {
            return value;
        }
        char[] replaced = new char[orig.length - equal * 2];
        int o = 0;
        for (int r = 0; r < replaced.length; ++r) {
            if ('=' == orig[o]) {
                if (orig[o + 1] == '2' && orig[o + 2] == 'C') {
                    replaced[r] = 44;
                } else if (orig[o + 1] == '3' && orig[o + 2] == 'D') {
                    replaced[r] = 61;
                }
                o += 3;
                continue;
            }
            replaced[r] = orig[o];
            ++o;
        }
        return new String(replaced);
    }

    @NotNull
    static String base64Encode(byte @NotNull [] value) {
        Preconditions.checkNotNull(value, "value");
        return new String(Base64.getEncoder().encode(value), StandardCharsets.UTF_8);
    }

    static byte @NotNull [] base64Decode(@NotNull String value) {
        Preconditions.checkNotEmpty(value, "value");
        return Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
    }
}

