/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.client;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.client.ClientFinalProcessor;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ClientFirstMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ServerFirstMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.StringPreparation;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;

final class ServerFirstProcessor {
    private final ScramMechanism scramMechanism;
    private final StringPreparation stringPreparation;
    private final ClientFirstMessage clientFirstMessage;
    private final ServerFirstMessage serverFirstMessage;

    ServerFirstProcessor(ScramMechanism scramMechanism, StringPreparation stringPreparation, @NotNull String receivedServerFirstMessage, @NotNull String nonce, @NotNull ClientFirstMessage clientFirstMessage) throws ScramParseException {
        this.scramMechanism = scramMechanism;
        this.stringPreparation = stringPreparation;
        this.serverFirstMessage = ServerFirstMessage.parseFrom(receivedServerFirstMessage, nonce);
        this.clientFirstMessage = clientFirstMessage;
    }

    @NotNull
    ServerFirstMessage getServerFirstMessage() {
        return this.serverFirstMessage;
    }

    ClientFinalProcessor clientFinalProcessor(char[] password) {
        return new ClientFinalProcessor(this.scramMechanism, this.stringPreparation, Preconditions.checkNotEmpty(password, "password"), Base64.getDecoder().decode(this.serverFirstMessage.getSalt().getBytes(StandardCharsets.UTF_8)), this.clientFirstMessage, this.serverFirstMessage);
    }

    ClientFinalProcessor clientFinalProcessor(byte[] clientKey, byte[] serverKey) {
        return new ClientFinalProcessor(this.scramMechanism, Preconditions.checkNotNull(clientKey, "clientKey"), Preconditions.checkNotNull(serverKey, "serverKey"), this.clientFirstMessage, this.serverFirstMessage);
    }

    ClientFinalProcessor clientFinalProcessor(byte[] saltedPassword) {
        return new ClientFinalProcessor(this.scramMechanism, Preconditions.checkNotNull(saltedPassword, "saltedPassword"), this.clientFirstMessage, this.serverFirstMessage);
    }
}

