/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.replication.fluent;

import io.yellowbrick.shaded.org.postgresql.core.BaseConnection;
import io.yellowbrick.shaded.org.postgresql.core.ReplicationProtocol;
import io.yellowbrick.shaded.org.postgresql.replication.PGReplicationStream;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.ChainedStreamBuilder;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.logical.LogicalStreamBuilder;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.logical.StartLogicalReplicationCallback;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.physical.PhysicalStreamBuilder;
import io.yellowbrick.shaded.org.postgresql.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

