/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.gss;

import io.yellowbrick.shaded.org.postgresql.util.internal.PgBufferedOutputStream;
import java.io.IOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class GSSOutputStream
extends PgBufferedOutputStream {
    private final PgBufferedOutputStream pgOut;
    private final GSSContext gssContext;
    private final MessageProp messageProp;

    public GSSOutputStream(PgBufferedOutputStream out, GSSContext gssContext, MessageProp messageProp, int maxTokenSize) throws GSSException {
        super(out, GSSOutputStream.getBufferSize(gssContext, messageProp, maxTokenSize));
        this.pgOut = out;
        this.gssContext = gssContext;
        this.messageProp = messageProp;
    }

    private static int getBufferSize(GSSContext gssContext, MessageProp messageProp, int maxTokenSize) throws GSSException {
        return gssContext.getWrapSizeLimit(messageProp.getQOP(), messageProp.getPrivacy(), maxTokenSize);
    }

    @Override
    protected void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.writeWrapped(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    private void writeWrapped(byte[] b, int off, int len) throws IOException {
        try {
            byte[] token = this.gssContext.wrap(b, off, len, this.messageProp);
            this.pgOut.writeInt4(token.length);
            this.pgOut.write(token, 0, token.length);
        }
        catch (GSSException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.count > 0) {
            int avail = this.buf.length - this.count;
            int prefixLength = Math.min(len, avail);
            System.arraycopy(b, off, this.buf, this.count, prefixLength);
            this.count += prefixLength;
            off += prefixLength;
            len -= prefixLength;
            if (this.count == this.buf.length) {
                this.flushBuffer();
            }
        }
        while (len >= this.buf.length) {
            this.writeWrapped(b, off, this.buf.length);
            off += this.buf.length;
            len -= this.buf.length;
        }
        if (len == 0) {
            return;
        }
        System.arraycopy(b, off, this.buf, 0, len);
        this.count += len;
    }
}

