/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.fastpath;

import io.yellowbrick.shaded.org.postgresql.core.ParameterList;
import io.yellowbrick.shaded.org.postgresql.util.ByteStreamWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FastpathArg {
    private final byte @Nullable [] bytes;
    private final int bytesStart;
    private final int bytesLength;

    public FastpathArg(int value) {
        this.bytes = new byte[4];
        this.bytes[3] = (byte)value;
        this.bytes[2] = (byte)(value >> 8);
        this.bytes[1] = (byte)(value >> 16);
        this.bytes[0] = (byte)(value >> 24);
        this.bytesStart = 0;
        this.bytesLength = 4;
    }

    public FastpathArg(long value) {
        this.bytes = new byte[8];
        this.bytes[7] = (byte)value;
        this.bytes[6] = (byte)(value >> 8);
        this.bytes[5] = (byte)(value >> 16);
        this.bytes[4] = (byte)(value >> 24);
        this.bytes[3] = (byte)(value >> 32);
        this.bytes[2] = (byte)(value >> 40);
        this.bytes[1] = (byte)(value >> 48);
        this.bytes[0] = (byte)(value >> 56);
        this.bytesStart = 0;
        this.bytesLength = 8;
    }

    public FastpathArg(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public FastpathArg(byte @Nullable [] buf, int off, int len) {
        this.bytes = buf;
        this.bytesStart = off;
        this.bytesLength = len;
    }

    public FastpathArg(String s) {
        this(s.getBytes(Charset.defaultCharset()));
    }

    public static FastpathArg of(ByteStreamWriter writer) {
        return new ByteStreamWriterFastpathArg(writer);
    }

    void populateParameter(ParameterList params, int index) throws SQLException {
        if (this.bytes == null) {
            params.setNull(index, 0);
        } else {
            params.setBytea(index, this.bytes, this.bytesStart, this.bytesLength);
        }
    }

    static class ByteStreamWriterFastpathArg
    extends FastpathArg {
        private final ByteStreamWriter writer;

        ByteStreamWriterFastpathArg(ByteStreamWriter writer) {
            super(null, 0, 0);
            this.writer = writer;
        }

        @Override
        void populateParameter(ParameterList params, int index) throws SQLException {
            params.setBytea(index, this.writer);
        }
    }
}

