/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.oauth2;

import io.yellowbrick.jdbc.DriverConfiguration;
import io.yellowbrick.jdbc.oauth2.OAuth2Authorizer;
import io.yellowbrick.jdbc.oauth2.Token;
import io.yellowbrick.shaded.org.json.JSONArray;
import io.yellowbrick.shaded.org.json.JSONObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TokenService {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private static TokenService instance;
    private final ConcurrentHashMap<String, Token> cache = new ConcurrentHashMap();
    private final AtomicBoolean cacheLoaded = new AtomicBoolean(false);
    static String CACHE_FILE_NAME;

    private TokenService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenService getInstance() {
        if (instance != null) return instance;
        Class<TokenService> clazz = TokenService.class;
        synchronized (TokenService.class) {
            if (instance != null) return instance;
            instance = new TokenService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Token getToken(DriverConfiguration driverConfiguration, String url, Properties info) throws SQLException {
        String connection;
        String key;
        Token token;
        if (driverConfiguration.tokenCache == DriverConfiguration.TokenCacheOption.DISABLED) {
            return new OAuth2Authorizer(driverConfiguration, url, info).getOAuth2AccessToken();
        }
        if (driverConfiguration.tokenCache == DriverConfiguration.TokenCacheOption.FILE && !this.cacheLoaded.compareAndExchange(false, true)) {
            this.loadTokenCache();
        }
        if ((token = this.cache.get(key = TokenService.buildTokenCacheHash(connection = Token.extractConnectionInfo(url), info))) != null) {
            if (token.getExpiresAt().isBefore(Instant.now())) {
                if (token.getRefreshToken() != null) {
                    try {
                        token = new OAuth2Authorizer(driverConfiguration, url, info).refreshOAuth2AccessToken(token.getRefreshToken());
                        if (token != null) {
                            this.cache.put(key, token);
                            if (driverConfiguration.tokenCache == DriverConfiguration.TokenCacheOption.FILE) {
                                this.storeTokenCache();
                            }
                            return token;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.cache.remove(key);
            } else if (token.matches(connection, info)) {
                return token;
            }
        }
        if ((token = new OAuth2Authorizer(driverConfiguration, url, info).getOAuth2AccessToken()) != null) {
            this.cache.put(key, token);
            if (driverConfiguration.tokenCache == DriverConfiguration.TokenCacheOption.FILE) {
                this.storeTokenCache();
            }
            return token;
        }
        return null;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String buildTokenCacheHash(String connection, Properties info) throws SQLException {
        TreeMap<Object, String> sortedProps = new TreeMap<Object, String>();
        Iterator<String> iterator = info.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            Object name;
            String string = info.getProperty((String)(name = iterator.next()));
            sortedProps.put(name, string != null ? string : "");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sortedProps.entrySet()) {
            if ("password".equalsIgnoreCase((String)entry.getKey()) || "database".equalsIgnoreCase((String)entry.getKey()) || "databaseName".equalsIgnoreCase((String)entry.getKey())) continue;
            sb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append(';');
        }
        sb.append("connection=").append(connection).append(';');
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = digest.digest(sb.toString().getBytes(StandardCharsets.UTF_8));
            return TokenService.bytesToHex(byArray);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found", e);
        }
    }

    private void loadTokenCache() throws SQLException {
        Path tokenCacheFile = this.getTokenCacheFile();
        try {
            if (!Files.exists(tokenCacheFile, new LinkOption[0])) {
                return;
            }
            String content = Files.readString(tokenCacheFile, StandardCharsets.UTF_8);
            JSONArray jsonArray = new JSONArray(content);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                Token token = Token.fromJSONObject(obj);
                String hash = TokenService.buildTokenCacheHash(token.getConnection(), token.getInfo());
                this.cache.put(hash, token);
            }
        }
        catch (IOException e) {
            throw new SQLException("Failed to load token cache: " + String.valueOf(tokenCacheFile), e);
        }
    }

    private void storeTokenCache() throws SQLException {
        try {
            JSONArray jsonArray = new JSONArray();
            for (Token token : this.cache.values()) {
                if (token.getTokenCacheOption() != DriverConfiguration.TokenCacheOption.FILE) continue;
                jsonArray.put(token.toJSONObject());
            }
            Path tokenCacheFile = this.getTokenCacheFile();
            Files.createDirectories(tokenCacheFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(tokenCacheFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write(jsonArray.toString(2));
            }
            try {
                Files.setPosixFilePermissions(tokenCacheFile, PosixFilePermissions.fromString("rw-------"));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        catch (IOException e) {
            throw new SQLException("Failed to store token cache", e);
        }
    }

    void deleteTokenCache() {
        File tokenCacheFile = this.getTokenCacheFile().toFile();
        if (tokenCacheFile.exists()) {
            tokenCacheFile.delete();
        }
        this.clearTokenCache();
    }

    void clearTokenCache() {
        this.cache.clear();
        this.cacheLoaded.set(false);
    }

    private Path getTokenCacheFile() {
        return Paths.get(System.getProperty("user.home"), ".yb", "token", CACHE_FILE_NAME);
    }

    static {
        CACHE_FILE_NAME = "token-cache.json";
    }
}

