/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.oauth2;

import io.yellowbrick.jdbc.DriverConfiguration;
import io.yellowbrick.shaded.org.json.JSONObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class Token {
    private final String authToken;
    private final String refreshToken;
    private final Instant expiresAt;
    private final String connection;
    private final Properties info;

    public static Token createToken(String authToken, String refreshToken, Instant expiresAt, String url, Properties info) throws SQLException {
        return new Token(authToken, refreshToken, expiresAt, Token.extractConnectionInfo(url), info);
    }

    private Token(String authToken, String refreshToken, Instant expiresAt, String connection, Properties info) {
        this.authToken = authToken;
        this.refreshToken = refreshToken;
        this.expiresAt = expiresAt;
        this.connection = connection;
        this.info = Token.copyOf(info);
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public String getConnection() {
        return this.connection;
    }

    public Properties getInfo() {
        return this.info;
    }

    public DriverConfiguration.TokenCacheOption getTokenCacheOption() {
        return DriverConfiguration.TokenCacheOption.fromString(this.info.getProperty("oauth2TokenCache", "memory"));
    }

    public static Properties copyOf(Properties info) {
        Properties result = new Properties();
        for (String key : info.stringPropertyNames()) {
            if (key.equalsIgnoreCase("password")) continue;
            result.setProperty(key, info.getProperty(key));
        }
        return result;
    }

    public boolean matches(String connection, Properties info) {
        return this.connection.equals(connection) && Objects.equals(this.info, Token.copyOf(info));
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put("authToken", this.authToken);
        json.put("refreshToken", this.refreshToken);
        json.put("expiresAt", this.expiresAt != null ? this.expiresAt.toString() : null);
        json.put("connection", this.connection);
        JSONObject infoJson = new JSONObject();
        for (Map.Entry<Object, Object> entry : this.info.entrySet()) {
            infoJson.put(entry.getKey().toString(), entry.getValue().toString());
        }
        json.put("info", infoJson);
        return json;
    }

    public static Token fromJSONObject(JSONObject json) throws SQLException {
        String url;
        String authToken = json.optString("authToken", null);
        String refreshToken = json.optString("refreshToken", null);
        String expiresAtStr = json.optString("expiresAt", null);
        Instant expiresAt = expiresAtStr != null ? Instant.parse(expiresAtStr) : null;
        String connection = json.optString("connection", null);
        if (connection == null && (url = json.optString("url", null)) != null) {
            connection = Token.extractConnectionInfo(url);
        }
        Properties info = new Properties();
        JSONObject infoJson = json.optJSONObject("info");
        if (infoJson != null) {
            Map<String, Object> infoMap = infoJson.toMap();
            for (Map.Entry<String, Object> entry : infoMap.entrySet()) {
                info.setProperty(entry.getKey(), entry.getValue().toString());
            }
        }
        return new Token(authToken, refreshToken, expiresAt, connection, info);
    }

    static String extractConnectionInfo(String jdbcUrl) throws SQLException {
        try {
            if (!jdbcUrl.startsWith("jdbc:")) {
                throw new SQLException("Invalid JDBC URL: must start with 'jdbc:'");
            }
            String rawUrl = jdbcUrl.substring(5);
            rawUrl = rawUrl.replaceFirst("^(?i)(postgresql|yb):(?=[^/]*:)", "$1://");
            URI uri = new URI(rawUrl);
            StringBuilder result = new StringBuilder();
            if (uri.getHost() == null) {
                throw new SQLException(String.format("Could not parse JDBC URL: %s", jdbcUrl));
            }
            result.append(uri.getScheme()).append(":").append(uri.getHost());
            if (uri.getPort() != -1) {
                result.append(":").append(uri.getPort());
            }
            if (uri.getQuery() != null) {
                result.append("?").append(uri.getQuery());
            }
            return result.toString();
        }
        catch (URISyntaxException e) {
            throw new SQLException("Failed to parse JDBC URL: " + jdbcUrl, e);
        }
    }
}

