/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.oauth2;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class FormParameterEncoder {
    FormParameterEncoder() {
    }

    static String toFormEncoding(Map<String, ?> params) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            if (!first) {
                result.append("&");
            }
            first = false;
            result.append(FormParameterEncoder.encodeValue(entry.getKey(), StandardCharsets.UTF_8));
            result.append("=");
            result.append(FormParameterEncoder.encodeValue(String.valueOf(entry.getValue()), StandardCharsets.UTF_8));
        }
        return result.toString();
    }

    static String encodeValue(String s, Charset charset) {
        StringBuilder encoded = new StringBuilder();
        for (char c : s.toCharArray()) {
            byte[] bytes;
            if (FormParameterEncoder.isSafeChar(c)) {
                encoded.append(c);
                continue;
            }
            if (c == ' ') {
                encoded.append('+');
                continue;
            }
            for (byte b : bytes = String.valueOf(c).getBytes(charset)) {
                encoded.append('%');
                encoded.append(String.format("%02X", b));
            }
        }
        return encoded.toString();
    }

    static boolean isSafeChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~' || c == ':' || c == '/';
    }
}

