/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.help;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class YellowbrickDriverTester {
    public static void main(String[] args) {
        Connection conn;
        if (args.length < 5) {
            System.err.println("Usage: java -jar <jar> <host> <port> <database> <issuer> <clientId> <clientSecret>");
            System.exit(1);
        }
        String host = args[0];
        String port = args[1];
        String database = args[2];
        String issuer = args[3];
        String clientId = args[4];
        String clientSecret = args.length > 5 ? args[5] : null;
        String url = String.format("jdbc:yb://%s:%s/%s", host, port, database);
        Properties props = new Properties();
        props.setProperty("oauth2Issuer", issuer);
        props.setProperty("oauth2ClientId", clientId);
        if (clientSecret != null) {
            props.setProperty("oauth2ClientSecret", clientSecret);
        }
        props.setProperty("oauth2TokenCache", "file");
        System.out.printf("Please be sure that you have established external authentication configuration\nin your Yellowbrick database.\n\nSee: https://docs.yellowbrick.com/latest/ybd_sqlref/create_external_auth.html\n\n(SQL command for these parameters)\n\n  CREATE EXTERNAL AUTHENTICATION jdbc\n    issuer '%s'\n    user_mapping_claim 'preferred_username'\n    grant ('consumer')\n    audience ('{%s}')\n    auto_create\n    enabled;\n", issuer, clientId);
        System.out.println("\nAttempting to connect with URL: " + url);
        try {
            conn = DriverManager.getConnection(url, props);
            try {
                System.out.println("Connection successful!");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Connection failed: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            conn = DriverManager.getConnection(url, props);
            try {
                System.out.println("Second connection successful; should have cached!");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Second connection failed: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

