/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.dialog;

import io.yellowbrick.jdbc.dialog.FrameFinder;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public final class DeviceCodeDialog {
    private DeviceCodeDialog() {
    }

    public static Runnable show(final String deviceAuthUrl, final String deviceAuthCode, Consumer<Boolean> result) {
        AtomicBoolean resultReturned = new AtomicBoolean();
        final Consumer<Boolean> returnResult = dialogResult -> {
            if (resultReturned.compareAndSet(false, true)) {
                result.accept((Boolean)dialogResult);
            }
        };
        Frame parent = FrameFinder.findTopLevelFrame().orElse(null);
        Dialog dlg = new Dialog(parent, "Sign In", false);
        dlg.setBackground(new Color(0xFFFFFF));
        dlg.setLayout(new GridBagLayout());
        dlg.setResizable(false);
        AtomicBoolean disposed = new AtomicBoolean();
        final Runnable dispose = () -> {
            if (disposed.compareAndSet(false, true)) {
                dlg.dispose();
            }
        };
        Panel mainPanel = new Panel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(50, 50, 20, 50);
        Panel headerPanel = new Panel(new GridBagLayout());
        Label title = new Label("Authenticate With Yellowbrick");
        title.setFont(new Font("SansSerif", 1, 20));
        headerPanel.add((Component)new LogoPanel(), new GridBagConstraints(0, 0, 0, 0, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        headerPanel.add((Component)title, new GridBagConstraints(1, 0, 0, 0, 0.0, 1.0, 17, 0, new Insets(0, 80, 0, 0), 0, 0));
        mainPanel.add((Component)headerPanel, c);
        ++c.gridy;
        c.insets = new Insets(4, 40, 6, 22);
        Panel instruct = new Panel(new FlowLayout(0, 4, 0));
        Label pre = new Label("Visit");
        pre.setFont(new Font("SansSerif", 0, 13));
        pre.setForeground(new Color(0x2B2B2B));
        instruct.add(pre);
        LinkLabel link = new LinkLabel(deviceAuthUrl);
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeviceCodeDialog.openUrl(deviceAuthUrl);
            }
        });
        instruct.add(link);
        Label post = new Label("and enter the code:");
        post.setFont(new Font("SansSerif", 0, 13));
        post.setForeground(new Color(0x2B2B2B));
        instruct.add(post);
        mainPanel.add((Component)instruct, c);
        TextField codeField = new TextField(deviceAuthCode, deviceAuthCode.length() + 1);
        codeField.setEditable(false);
        codeField.setFont(new Font("Monospaced", 1, 24));
        codeField.setBackground(new Color(16119798));
        codeField.setForeground(new Color(0x1E1E1E));
        final ToastPanel toastPanel = new ToastPanel();
        MouseAdapter copyToClipboardListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cb.setContents(new StringSelection(deviceAuthCode), null);
                    toastPanel.showToast("Copied!");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        toastPanel.addMouseListener(copyToClipboardListener);
        ClipboardButton copyBtn = new ClipboardButton("Copy");
        copyBtn.addMouseListener(copyToClipboardListener);
        Button loginBtn = new Button("Login");
        loginBtn.setPreferredSize(new Dimension(100, 38));
        loginBtn.addActionListener(e -> DeviceCodeDialog.openUrl(deviceAuthUrl));
        Panel codeSpacer = new Panel();
        codeSpacer.setPreferredSize(new Dimension(16, 16));
        Panel codePanel = new Panel(new FlowLayout(0, 8, 8));
        codePanel.addMouseListener(copyToClipboardListener);
        codePanel.setBackground(new Color(16119798));
        codePanel.add(codeField);
        codePanel.add(copyBtn);
        ++c.gridy;
        c.insets = new Insets(18, 22, 2, 22);
        c.fill = 2;
        c.weightx = 1.0;
        Panel codeRow = new Panel(new FlowLayout(1, 0, 0));
        codeRow.add(codePanel);
        codeRow.add(codeSpacer);
        codeRow.add(loginBtn);
        mainPanel.add((Component)codeRow, c);
        ++c.gridy;
        c.insets = new Insets(0, 22, 0, 22);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)toastPanel, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.anchor = 14;
        c.insets = new Insets(0, 22, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        Panel footerPanel = new Panel(new FlowLayout(2, 0, 0));
        Button cancel = new Button("Cancel");
        cancel.setPreferredSize(new Dimension(100, 38));
        cancel.addActionListener(e -> {
            returnResult.accept(false);
            dispose.run();
        });
        footerPanel.add(cancel);
        footerPanel.setPreferredSize(new Dimension(100, 40));
        mainPanel.add((Component)footerPanel, c);
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    returnResult.accept(false);
                    dispose.run();
                }
                if (e.getKeyCode() == 10) {
                    DeviceCodeDialog.openUrl(deviceAuthUrl);
                }
            }
        };
        for (Component comp : new Component[]{mainPanel, codeField, copyBtn, loginBtn, cancel, link}) {
            comp.addKeyListener(ka);
        }
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                returnResult.accept(false);
                dispose.run();
            }
        });
        GridBagConstraints outer = new GridBagConstraints();
        outer.gridx = 0;
        outer.gridy = 0;
        outer.anchor = 10;
        outer.insets = new Insets(24, 24, 24, 24);
        outer.weightx = 1.0;
        outer.weighty = 1.0;
        outer.fill = 1;
        dlg.add((Component)mainPanel, outer);
        dlg.pack();
        Dimension sz = dlg.getSize();
        if (sz.width < 540) {
            sz.width = 540;
        }
        if (sz.height < 340) {
            sz.height = 340;
        }
        dlg.setSize(sz);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        EventQueue.invokeLater(() -> {
            dlg.setAlwaysOnTop(true);
            dlg.toFront();
            dlg.requestFocus();
            dlg.setAlwaysOnTop(false);
        });
        return () -> dispose.run();
    }

    private static void openUrl(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        DeviceCodeDialog.show("https://microsoft.com/devicelogin", "ALWD68P34", ok -> {
            System.out.println("Login pressed? " + ok);
            System.exit(0);
        });
    }

    static final class ClipboardButton
    extends Canvas {
        private final Image icon = Toolkit.getDefaultToolkit().getImage(DeviceCodeDialog.class.getResource("clipboard_24x24.png"));

        ClipboardButton(String accessibilityName) {
            this.setName(accessibilityName);
            this.setCursor(new Cursor(12));
            this.setSize(40, 40);
            this.setBackground(new Color(16119798));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(40, 40);
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.icon, 4, 8, 24, 24, this);
        }
    }

    static final class LinkLabel
    extends Label {
        LinkLabel(String text) {
            super(text);
            this.setForeground(new Color(8830029));
            this.setFont(new Font("SansSerif", 1, 13));
            this.setCursor(new Cursor(12));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            FontMetrics fm = g.getFontMetrics();
            int y = this.getHeight() - fm.getDescent() + 1;
            g.drawLine(0, y, fm.stringWidth(this.getText()), y);
        }
    }

    static final class ToastPanel
    extends Panel {
        private String toast;

        ToastPanel() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.toast != null) {
                Font smallFont = this.getFont().deriveFont(0, 11.0f);
                g.setFont(smallFont);
                int w = this.getWidth();
                FontMetrics fm = g.getFontMetrics(this.getFont());
                int tw = fm.stringWidth(this.toast) + 12;
                int th = fm.getHeight() + 8;
                int x = (w - tw) / 2 - 6;
                int y = 6;
                g.setColor(new Color(0, 0, 0, 180));
                g.fillRoundRect(x, y, tw, th, 10, 10);
                int arrowW = 10;
                int arrowH = 6;
                int arrowX = x + tw / 2 - arrowW / 2;
                int arrowY = y - arrowH;
                int[] px = new int[]{arrowX, arrowX + arrowW, arrowX + arrowW / 2};
                int[] py = new int[]{arrowY + arrowH, arrowY + arrowH, arrowY};
                g.fillPolygon(px, py, 3);
                g.setColor(Color.white);
                g.drawString(this.toast, x + 10, y + th - fm.getDescent() - 4);
            }
        }

        void showToast(String text) {
            this.toast = text;
            new Timer(true).schedule(new TimerTask(){

                @Override
                public void run() {
                    EventQueue.invokeLater(() -> {
                        toast = null;
                        this.repaint();
                    });
                }
            }, 1400L);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, 80);
        }
    }

    static final class LogoPanel
    extends Panel {
        private Image logo = Toolkit.getDefaultToolkit().getImage(DeviceCodeDialog.class.getResource("yb_logo_80x80.png"));

        LogoPanel() {
            Dimension fixedSize = new Dimension(80, 80);
            this.setSize(fixedSize);
            this.setPreferredSize(fixedSize);
            this.setMinimumSize(fixedSize);
            this.setMaximumSize(fixedSize);
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getSize() {
            return super.getSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return super.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getMinimumSize();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.logo, 0, 0, 80, 80, this);
        }
    }
}

