/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc;

import io.yellowbrick.jdbc.DriverConfiguration;
import io.yellowbrick.jdbc.DriverConstants;
import io.yellowbrick.jdbc.oauth2.Token;
import io.yellowbrick.jdbc.oauth2.TokenService;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class YellowbrickDriver
implements Driver,
DriverConstants {
    private final Driver delegate;

    public YellowbrickDriver() {
        try {
            this.delegate = (Driver)Class.forName("io.yellowbrick.shaded.org.postgresql.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load shaded PostgreSQL driver", e);
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Object rewrittenUrl = url;
        if (url.startsWith("jdbc:yb:")) {
            rewrittenUrl = "jdbc:postgresql:" + url.substring("jdbc:yb:".length());
        }
        String issuer = info.getProperty("oauth2Issuer");
        String clientId = info.getProperty("oauth2ClientId");
        if (issuer != null && clientId != null) {
            DriverConfiguration driverConfiguration = new DriverConfiguration(info);
            Token token = TokenService.getInstance().getToken(driverConfiguration, url, info);
            if (token == null) {
                throw new SQLException("Failed to obtain OAuth2 access token");
            }
            Properties infoCopy = new Properties();
            infoCopy.putAll((Map<?, ?>)info);
            infoCopy.put("user", String.format("jwt:%s", token.getAuthToken()));
            infoCopy.put("password", "");
            info = infoCopy;
        }
        return this.delegate.connect((String)rewrittenUrl, info);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url != null && (url.startsWith("jdbc:yb:") || url.startsWith("jdbc:postgresql:"));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo reWriteBatchedInserts;
        DriverPropertyInfo defaultRowFetchSize;
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo authIssuer = new DriverPropertyInfo("oauth2Issuer", info.getProperty("oauth2Issuer"));
        authIssuer.description = "The OAuth2 issuer URL. Required for OAuth2 endpoint discovery.";
        authIssuer.required = true;
        props.add(authIssuer);
        DriverPropertyInfo clientId = new DriverPropertyInfo("oauth2ClientId", info.getProperty("oauth2ClientId"));
        clientId.description = "OAuth2 client ID for authentication. Must be registered with the issuer.";
        clientId.required = true;
        props.add(clientId);
        DriverPropertyInfo clientSecret = new DriverPropertyInfo("oauth2ClientSecret", info.getProperty("oauth2ClientSecret"));
        clientSecret.description = "Optional OAuth2 client secret (used for confidential clients).";
        clientSecret.required = false;
        props.add(clientSecret);
        DriverPropertyInfo loginHint = new DriverPropertyInfo("oauth2LoginHint", info.getProperty("oauth2LoginHint"));
        loginHint.description = "Optional login_hint to suggest the user's identity to the OAuth2 provider.";
        loginHint.required = false;
        props.add(loginHint);
        DriverPropertyInfo audience = new DriverPropertyInfo("oauth2Audience", info.getProperty("oauth2Audience"));
        audience.description = "The OAuth2 audience setting. Not required for all IDPs, but some may allow it or require it.";
        audience.required = false;
        props.add(audience);
        String scopesValue = info.getProperty("oauth2Scopes", "openid email profile offline_access");
        DriverPropertyInfo scopes = new DriverPropertyInfo("oauth2Scopes", scopesValue);
        scopes.description = "Space-separated OAuth2 scopes to request. Default is: openid email profile offline_access";
        scopes.required = false;
        props.add(scopes);
        String tokenTypeValue = info.getProperty("oauth2TokenType", "id-token");
        DriverPropertyInfo tokenType = new DriverPropertyInfo("oauth2TokenType", tokenTypeValue);
        tokenType.description = "OAuth2 token type to use for login. Default is: id-token";
        tokenType.choices = YB_JDBC_OAUTH2_TOKEN_OPTIONS;
        tokenType.required = false;
        props.add(tokenType);
        String tokenCacheValue = info.getProperty("oauth2TokenCache", "memory");
        DriverPropertyInfo tokenCache = new DriverPropertyInfo("oauth2TokenCache", tokenCacheValue);
        tokenCache.description = "OAuth2 token cache to use for handling sessions. Default is: memory";
        tokenCache.choices = YB_JDBC_OAUTH2_TOKEN_CACHE_OPTIONS;
        tokenCache.required = false;
        props.add(tokenCache);
        DriverPropertyInfo cacertPath = new DriverPropertyInfo("oauth2CAcertPath", info.getProperty("oauth2CAcertPath"));
        cacertPath.description = "Path to a custom CA certificate file to verify the issuer's TLS certificate.";
        cacertPath.required = false;
        props.add(cacertPath);
        String interactionModeValue = info.getProperty("oauth2InteractionMode", "browser");
        DriverPropertyInfo interactionMode = new DriverPropertyInfo("oauth2InteractionMode", interactionModeValue);
        interactionMode.description = "OAuth2 interaction mode for presenting device code (dialog, browser, or console). Default is: browser";
        interactionMode.choices = YB_JDBC_OAUTH2_INTERACTION_MODE_OPTIONS;
        interactionMode.required = false;
        props.add(interactionMode);
        Collections.addAll(props, this.delegate.getPropertyInfo(url, info));
        DriverPropertyInfo appName = props.stream().filter(p -> p.name.equals("ApplicationName")).findFirst().orElse(null);
        if (appName != null) {
            appName.value = "Yellowbrick JDBC Driver";
        }
        if ((defaultRowFetchSize = (DriverPropertyInfo)props.stream().filter(p -> p.name.equals("defaultRowFetchSize")).findFirst().orElse(null)) != null) {
            defaultRowFetchSize.value = "10000";
        }
        if ((reWriteBatchedInserts = (DriverPropertyInfo)props.stream().filter(p -> p.name.equals("reWriteBatchedInserts")).findFirst().orElse(null)) != null) {
            reWriteBatchedInserts.value = "true";
        }
        return props.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.delegate.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getGlobal();
    }

    static {
        try {
            DriverManager.registerDriver(new YellowbrickDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register driver", e);
        }
    }
}

