/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.mail;

import com.dbeaver.data.transfer.mail.SMTPAuthentication;
import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.google.gson.Gson;
import com.google.gson.Strictness;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.CommonUtils;

public final class SMTPProfileManager {
    private static final String CONFIGURATION_FILE = "smtp-profiles.json";
    private static final Log log = Log.getLog(SMTPProfileManager.class);
    private static final Gson gson = PropertySerializationUtils.baseNonSecurePropertiesGsonBuilder().setPrettyPrinting().setStrictness(Strictness.STRICT).create();
    private static final List<SMTPProfile> cachedProfiles = new ArrayList<SMTPProfile>();

    private SMTPProfileManager() {
    }

    @Nullable
    public static SMTPProfile getProfile(@NotNull String id) {
        for (SMTPProfile profile : SMTPProfileManager.getProfiles()) {
            if (!profile.getId().equals(id)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public static synchronized List<SMTPProfile> getProfiles() {
        if (cachedProfiles.isEmpty()) {
            ArrayList<SMTPProfile> profiles = new ArrayList<SMTPProfile>();
            try {
                profiles.addAll(SMTPProfileManager.loadLegacyProfiles());
                profiles.addAll(SMTPProfileManager.loadProfiles());
            }
            catch (DBException e) {
                log.error((Object)"Error loading SMTP profiles", (Throwable)e);
                return List.of();
            }
            cachedProfiles.clear();
            cachedProfiles.addAll(profiles);
        }
        return cachedProfiles;
    }

    public static synchronized void setProfiles(@NotNull List<SMTPProfile> profiles) throws DBException {
        cachedProfiles.clear();
        try {
            SMTPProfileManager.cleanupLegacyProfiles();
        }
        catch (Exception e) {
            log.debug((Object)"Error removing legacy SMTP preferences", (Throwable)e);
        }
        profiles = profiles.stream().map(SMTPProfileManager::copyProfile).toList();
        DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(CONFIGURATION_FILE, gson.toJson(profiles));
        DBSSecretController secrets = SMTPProfileManager.getSecretController();
        for (SMTPProfile profile : profiles) {
            SMTPAuthentication auth = profile.getAuthentication();
            secrets.setPrivateSecretValue(SMTPProfileManager.getSecretId(profile, "username"), auth != null ? auth.getUsername() : null);
            secrets.setPrivateSecretValue(SMTPProfileManager.getSecretId(profile, "password"), auth != null ? auth.getPassword() : null);
        }
        secrets.flushChanges();
    }

    @Nullable
    static SMTPAuthentication loadAuthentication(@NotNull SMTPProfile profile) throws DBException {
        DBSSecretController secrets = SMTPProfileManager.getSecretController();
        String username = CommonUtils.notEmpty((String)secrets.getPrivateSecretValue(SMTPProfileManager.getSecretId(profile, "username")));
        String password = CommonUtils.notEmpty((String)secrets.getPrivateSecretValue(SMTPProfileManager.getSecretId(profile, "password")));
        if (CommonUtils.isEmpty((String)username)) {
            return null;
        }
        return new SMTPAuthentication(username, password);
    }

    @NotNull
    private static List<SMTPProfile> loadProfiles() throws DBException {
        String config = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(CONFIGURATION_FILE);
        if (CommonUtils.isEmpty((String)config)) {
            return List.of();
        }
        try {
            return List.of((SMTPProfile[])gson.fromJson(config, SMTPProfile[].class));
        }
        catch (Exception e) {
            log.error((Object)"Error deserializing SMTP profiles", (Throwable)e);
            return List.of();
        }
    }

    @NotNull
    private static List<SMTPProfile> loadLegacyProfiles() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        int count = preferences.getInt("mail.profiles.count");
        if (count == 0) {
            return List.of();
        }
        ArrayList<SMTPProfileLegacy> profiles = new ArrayList<SMTPProfileLegacy>();
        int i = 0;
        while (i < count) {
            profiles.add(new SMTPProfileLegacy(preferences.getString("mail.profiles." + i + ".id"), preferences.getString("mail.profiles." + i + ".hostname"), preferences.getInt("mail.profiles." + i + ".port"), i));
            ++i;
        }
        return List.copyOf(profiles);
    }

    private static void cleanupLegacyProfiles() throws DBException, IOException {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        int count = preferences.getInt("mail.profiles.count");
        if (count == 0) {
            return;
        }
        DBSSecretController secrets = SMTPProfileManager.getSecretController();
        int i = 0;
        while (i < count) {
            secrets.setPrivateSecretValue(SMTPProfileManager.getLegacySecretId(i, "username"), null);
            secrets.setPrivateSecretValue(SMTPProfileManager.getLegacySecretId(i, "password"), null);
            preferences.setToDefault("mail.profiles." + i + ".id");
            preferences.setToDefault("mail.profiles." + i + ".hostname");
            preferences.setToDefault("mail.profiles." + i + ".port");
            ++i;
        }
        preferences.setToDefault("mail.profiles.count");
        preferences.save();
        secrets.flushChanges();
    }

    @NotNull
    private static String getLegacySecretId(int profileIndex, @NotNull String key) {
        return "mail/profiles/" + profileIndex + "/" + key;
    }

    @NotNull
    private static String getSecretId(@NotNull SMTPProfile profile, @NotNull String key) {
        if (profile instanceof SMTPProfileLegacy) {
            SMTPProfileLegacy legacyProfile = (SMTPProfileLegacy)profile;
            return SMTPProfileManager.getLegacySecretId(legacyProfile.legacyProfileIndex, key);
        }
        return "mail/profiles/" + profile.getId() + "/" + key;
    }

    @NotNull
    private static DBSSecretController getSecretController() throws DBException {
        return DBSSecretController.getGlobalSecretController();
    }

    @NotNull
    private static SMTPProfile copyProfile(@NotNull SMTPProfile profile) {
        return new SMTPProfile(profile.getId(), profile.getHostname(), profile.getPort(), profile.getAuthentication());
    }

    private static final class SMTPProfileLegacy
    extends SMTPProfile {
        private final int legacyProfileIndex;

        SMTPProfileLegacy(@NotNull String id, @NotNull String hostname, int port, int legacyProfileIndex) {
            super(id, hostname, port, null);
            this.legacyProfileIndex = legacyProfileIndex;
        }
    }
}

