/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.s3.AWSFileSystemS3;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.AbstractFileSystemProvider;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AWSFileSystemProviderS3
extends AbstractFileSystemProvider {
    @NotNull
    public Path getPathByURI(@NotNull DBRProgressMonitor monitor, @NotNull URI uri, @NotNull DBFVirtualFileSystem[] fileSystems) throws DBException {
        String fsId = CommonUtils.toString((Object)uri.getHost(), (String)uri.getAuthority());
        return this.getFileSystemByID(monitor, uri, fileSystems, fsId);
    }

    @NotNull
    public AWSFileSystemS3[] getAvailableFileSystems(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project) throws DBException {
        ArrayList<AWSFileSystemS3> fsList = new ArrayList<AWSFileSystemS3>();
        for (AWSCloud cloud : AWSCloudUtils.getAllClouds()) {
            if (((AWSCloudConfiguration)cloud.getCloudConfiguration()).isS3Disabled()) continue;
            fsList.add(new AWSFileSystemS3(cloud, project.getSessionContext()));
        }
        return fsList.toArray(new AWSFileSystemS3[0]);
    }
}

